/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.SOASchemaBrowserDialog;
import oracle.bpm.designer.action.ModuleAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.navigator.ProjectNavigatorBuilder;
import oracle.bpm.lang.CharacterUtils;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.UUIDFactory;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.lang.XmlUUID;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.SOASchemaInfo;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.catalog.BpmObject;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.DynamicRef;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.TextFilter;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectContainerDialog
extends OkCancelDialog {
    public CatalogModule selectedModule;
    private boolean addExternalRef;
    private CheckBox basedOnCheckBox;
    private BpmObject baseObject;
    private ComponentCatalog componentCatalog;
    private TextField externalField;
    private CatalogObject externalSchema;
    private Msg helpMsg;
    private IdentifierTextField moduleField;
    private String name;
    private IdentifierTextField nameField;
    private CatalogModule parentModule;
    private Project project;
    private SOASchemaInfo soaSchemaInfo;

    public ObjectContainerDialog(UiWindow parent, Msg title, Msg help, String prefix, CatalogObject parentModule) {
        this(parent, title, help, prefix, parentModule, parentModule.getProject());
    }

    public ObjectContainerDialog(UiWindow parent, Msg title, Msg help, String prefix, CatalogObject parentModule, Project project) {
        this(parent, title, help, prefix, parentModule, project, true);
    }

    public ObjectContainerDialog(UiWindow parent, Msg title, Msg help, String prefix, Project project, @Nullable BpmObject baseObject) {
        this(parent, title, help, prefix, null, project, true, baseObject);
    }

    public ObjectContainerDialog(UiWindow parent, Msg title, Msg help, String prefix, CatalogObject parentModule, Project project, boolean addExternalRef) {
        this(parent, title, help, prefix, parentModule, project, addExternalRef, null);
    }

    private ObjectContainerDialog(UiWindow parent, Msg title, Msg help, String prefix, CatalogObject parentModule, Project project, boolean addExternalRef, @Nullable BpmObject baseObject) {
        super(parent, title, true);
        this.helpMsg = help;
        this.addExternalRef = addExternalRef;
        this.project = project;
        this.baseObject = baseObject;
        this.init(prefix, parentModule);
    }

    public String getHelpId() {
        String code = this.helpMsg != null ? "." + this.helpMsg.getCode() : "";
        return this.getHelpIdWithMsg() + code;
    }

    public String getObjectName() {
        return this.name;
    }

    public CatalogModule getParentModule() {
        return this.parentModule;
    }

    public void setTypeRepository(ComponentCatalog catalogRepository) {
        this.componentCatalog = catalogRepository;
    }

    public ComponentCatalog getTypeRepository() {
        return this.componentCatalog;
    }

    public void ok() {
        if (this.isOk()) {
            this.setObjectName(this.nameField.getText());
            this.setParentModule(this.selectedModule);
            this.close();
        } else {
            this.nameField.requestFocus();
        }
    }

    public CatalogObject getExternalSchema() {
        return this.externalSchema;
    }

    public SOASchemaInfo getSoaSchemaInfo() {
        return this.soaSchemaInfo;
    }

    private static String getDefaultName(String prefix, CatalogObject obj) {
        return obj == null ? prefix : obj.getObjectType().proposeInnerTypeName(prefix);
    }

    private static IdentifierTextField createInput(UiContainer parent, String currentString) {
        IdentifierTextField nameInput = new IdentifierTextField(parent, currentString, true, true);
        nameInput.setColumns(35);
        nameInput.setSelectionStart(0);
        nameInput.setSelectionEnd(nameInput.getText().length());
        return nameInput;
    }

    private static IdentifierTextField createModuleInput(UiContainer parent, String currentString) {
        IdentifierTextField field = new IdentifierTextField(parent, currentString, true, true){

            protected TextFilter createFilter() {
                return new TextFilter(){

                    public boolean accepts(String str, int offs) {
                        boolean result = true;
                        if (str != null) {
                            if (this.isBegin(str, offs, this.getText())) {
                                char ch = str.charAt(0);
                                result = CharacterUtils.isLetter(ch) || ch == '_';
                            }
                            for (int i = 0; result && i < str.length(); ++i) {
                                result = this.isAccepted(str.charAt(i));
                            }
                        }
                        return result;
                    }

                    private boolean isBegin(String str, int offs, String allText) {
                        return str.length() > 0 && (offs == 0 || allText.charAt(offs - 1) == '.');
                    }

                    private boolean isAccepted(char c) {
                        return CharacterUtils.isLetterOrDigit(c) || c == '_' || c == '.';
                    }

                    public String filter(String text, int offs) {
                        return text == null ? null : this.filter(this.getText(), text, offs);
                    }

                    private String filter(String allText, String text, int offs) {
                        if (this.isBegin(text, offs, allText)) {
                            char character = Character.toUpperCase(text.charAt(0));
                            return character + this.filter(allText + character, text.substring(1), offs + 1);
                        }
                        return text;
                    }
                };
            }
        };
        field.setColumns(35);
        field.setSelectionStart(0);
        field.setSelectionEnd(field.getText().length());
        return field;
    }

    private void setObjectName(String name) {
        this.name = name;
    }

    private boolean isOk() {
        String name = this.nameField.getText();
        if (!Identifier.isValid(name)) {
            this.showErrorMessage(DesignerMsg.INVALID_IDENTIFIER);
            return false;
        }
        if (!this.hasSelectedTypeDescription()) {
            this.showErrorMessage(DesignerMsg.NO_MODULE_SELECTED);
            return false;
        }
        try {
            this.selectedModule = this.getSelectedModule();
        }
        catch (AmbiguousTypeNameException e) {
            MessageDialog.showError((Throwable)e);
            return false;
        }
        if (this.selectedModule != null && (this.selectedModule.isDefault() || this.selectedModule.isSynthesized())) {
            MessageDialog.showError((Msg)DesignerMsg.INVALID_TARGET_MODULE);
            return false;
        }
        if (this.selectedModule == null) {
            int option = MessageDialog.showQuestion((UiContainer)null, (Msg)UIMsg.TO_MSG((String)this.getTitle()), (Msg)DesignerMsg.MODULE_NOT_EXIST_CREATE(this.getSelectedModuleName()), null, (int)6, null);
            try {
                if (option == 2 && this.createModule() != null) {
                    this.selectedModule = this.getSelectedModule();
                }
            }
            catch (TypeCatalogException e) {
                MessageDialog.showError((Throwable)e);
                return false;
            }
            catch (ProjectException e) {
                MessageDialog.showError((Throwable)e);
                return false;
            }
            if (this.selectedModule == null) {
                return false;
            }
        }
        if (this.selectedModule.getObjectType().hasInnerType(name)) {
            this.showErrorMessage(UIMsg.COMPONENT_NAME_ALREADY_EXISTS((String)name));
            return false;
        }
        if (this.addExternalRef && this.basedOnCheckBox.isSelected() && this.externalSchema == null) {
            this.showErrorMessage(DesignerMsg.NO_EXTERNAL_SCHEMA_SELECTED);
            return false;
        }
        ComponentCatalog catalog = this.project.getComponentCatalog();
        if (this.externalSchema != null) {
            String schemaName;
            String id;
            String namespace;
            if (this.soaSchemaInfo != null && this.soaSchemaInfo.isExternalToProject()) {
                XmlUUID xmlUUID = UUIDFactory.createXmlId(this.soaSchemaInfo.getXmlElementType(), this.soaSchemaInfo.getqName().getNamespaceURI(), this.soaSchemaInfo.getqName().getLocalPart());
                namespace = xmlUUID.getNamespace();
                id = xmlUUID.getId();
                schemaName = this.soaSchemaInfo.getqName().toString();
            } else {
                ObjectTypeDescription objectType = this.externalSchema.getObjectType();
                id = objectType.getId();
                namespace = objectType.asSchemaObject().getNamespace();
                schemaName = objectType.getText();
            }
            TypeRef prev = catalog.findBpmObjectBySchemaId(id);
            if (prev != null && !prev.get().isSynthesized()) {
                MessageDialog.showError((Msg)LibMsg.BPMO_FROM_SCHEMA_ALREADY_EXISTS(schemaName, prev));
                return false;
            }
            if (Str.isEmpty(namespace)) {
                MessageDialog.showError((Msg)LibMsg.BPMO_FROM_SCHEMA_WITH_EMPTY_NAMESPACE(schemaName));
                return false;
            }
        }
        return true;
    }

    private void setParentModule(CatalogModule parentModule) {
        this.parentModule = parentModule;
    }

    private String getSelectedModuleName() {
        String module = this.moduleField.getText();
        return module == null ? "" : module.trim();
    }

    private CatalogModule getSelectedModule() throws AmbiguousTypeNameException {
        CatalogObject typeRef;
        CatalogModule result = null;
        String module = this.moduleField.getText();
        if (!Str.isEmpty(module) && (typeRef = this.project.findCatalogObject(module)) != null) {
            result = typeRef.asModule();
        }
        return result;
    }

    private void selectModule() {
        CatalogModule module = ModuleAction.selectModule(this.project);
        if (module != null) {
            this.moduleField.setText(module.getText());
        }
    }

    private void browseSOASchema() {
        SOASchemaBrowserDialog dialog = AbstractStudioWorkbench.getInstance().getSOASchemaBrowserDialog(this.project);
        if (dialog.showDialog()) {
            this.soaSchemaInfo = dialog.getSOASchemaInfo();
            CatalogObject catalogObject = this.project.findSchemaElement(this.soaSchemaInfo.getXmlElementType(), this.soaSchemaInfo.getqName().getNamespaceURI(), this.soaSchemaInfo.getqName().getLocalPart());
            if (catalogObject != null) {
                this.externalField.setText(catalogObject.getText());
                this.externalSchema = catalogObject;
            } else {
                this.externalField.setText(this.soaSchemaInfo.getqName().toString());
                XmlUUID xmlId = UUIDFactory.createXmlId(this.soaSchemaInfo.getXmlElementType(), this.soaSchemaInfo.getqName().getNamespaceURI(), this.soaSchemaInfo.getqName().getLocalPart());
                this.externalSchema = CatalogObjectImpl.create((TypeRef)new DynamicRef(xmlId, xmlId.getNativeName(), this.project.getComponentCatalog()));
            }
        }
    }

    private void browseExternalAction() {
        final CatalogObject ext = this.project.getCatalogRoot().findInnerType("Ext");
        Sequence objects = ext.getDescendants(CatalogObject.class);
        final Sequence<CatalogObject> schemas = objects.select(new Predicate<CatalogObject>(){

            @Override
            public boolean check(@Nullable CatalogObject value) {
                return value != null && !value.isModule() && ComponentType.XML.getText().equals(value.getDelegate().getComponentType()) && !value.isHidden() && !ObjectContainerDialog.this.hasBpmNamespace(value);
            }
        });
        ProjectFilter filter = new ProjectFilter(){

            @NotNull
            public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer object) {
                if (object == ext) {
                    return schemas;
                }
                return object.getChildren();
            }

            public ProjectObjectContainer getParent(ProjectObject object) {
                return object == ext ? (ProjectObjectContainer)object.getParentObject() : ext;
            }
        };
        Predicate<CatalogObject> predicate = new Predicate<CatalogObject>(){

            @Override
            public boolean check(@Nullable CatalogObject value) {
                return value != ext && value != null && !value.isHidden();
            }
        };
        CatalogObject object = new ProjectNavigatorBuilder((ProjectObject)ext, DesignerMsg.BROWSE_SCHEMAS).filter(filter).initialSelection((ProjectObject)this.externalSchema).selectSingle(CatalogObject.class, predicate);
        if (object != null) {
            this.externalField.setText(object.getText());
            this.externalSchema = object;
        }
    }

    private boolean hasBpmNamespace(CatalogObject value) {
        String ns = value.getObjectType().getProperty("namespace");
        return ns != null && ns.startsWith("http://xmlns.oracle.com/bpm/bpmobject/");
    }

    private CatalogModule createModule() throws TypeCatalogException, ProjectException {
        CatalogModule root = this.project.getCatalogRoot();
        CatalogModule module = root.newModule(this.getSelectedModuleName());
        root.asMutable().addChild((ProjectObject)module);
        return module;
    }

    private boolean hasSelectedTypeDescription() {
        return this.getSelectedModuleName().length() != 0;
    }

    private void init(String prefix, CatalogObject parentModule) {
        this.setResizable(false);
        if (parentModule != null) {
            this.setTypeRepository(parentModule.getObjectType().getCatalog());
        }
        boolean existhelp = this.helpMsg != null;
        String colSpecs = "5dlu, 5dlu, pref, 5dlu, pref:grow, 3dlu, pref, 5dlu, pref, 5dlu";
        String rowSpecsHelp = existhelp ? "5dlu, pref," : "";
        rowSpecsHelp = this.addExternalRef ? rowSpecsHelp + "5dlu, pref," : rowSpecsHelp;
        String rowSpecs = rowSpecsHelp + "5dlu,  pref, 5dlu, pref, 5dlu";
        Panel container = new Panel(this.getContentPane());
        FormLayout layout = new FormLayout(colSpecs, rowSpecs);
        PanelBuilder builder = layout.createBuilder(container);
        CellConstraints cc = layout.createCellConstraints();
        this.nameField = ObjectContainerDialog.createInput((UiContainer)container, ObjectContainerDialog.getDefaultName(prefix, parentModule));
        this.moduleField = ObjectContainerDialog.createModuleInput((UiContainer)container, parentModule == null ? "" : parentModule.getText());
        Button browse = Button.createBrowse((UiContainer)container);
        browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ObjectContainerDialog.this.selectModule();
            }
        });
        int y = 2;
        if (existhelp) {
            String helpText = this.helpMsg.getString();
            builder.addSeparator(helpText, cc.xywh(2, y, 8, 1));
            y += 2;
        }
        builder.add((UiComponent)Label.create((UiContainer)container, (Msg)UIMsg.NAME), cc.xy(3, y));
        builder.add((UiComponent)this.nameField, cc.xywh(5, y, 3, 1));
        builder.add((UiComponent)Label.create((UiContainer)container, (Msg)DesignerMsg.DESTINATION_MODULE), cc.xy(3, y += 2));
        builder.add((UiComponent)this.moduleField, cc.xy(5, y));
        builder.add((UiComponent)browse, cc.xy(7, y));
        if (this.addExternalRef) {
            this.basedOnCheckBox = CheckBox.create((UiContainer)container, (Msg)DesignerMsg.BASED_ON_EXTERNAL_SCHEMA);
            builder.add((UiComponent)this.basedOnCheckBox, cc.xy(3, y += 2));
            this.externalField = new TextField((UiContainer)container, 20);
            this.externalField.setEnabled(false);
            final Button externalButton = Button.createEllipsis((UiContainer)container);
            externalButton.setEnabled(false);
            externalButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ObjectContainerDialog.this.browseExternalAction();
                }
            });
            final Button soaBrowserButton = Button.createIconic((UiContainer)container, (Msg)UIMsg.SCHEMA_BROWSER);
            soaBrowserButton.setEnabled(false);
            soaBrowserButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ObjectContainerDialog.this.browseSOASchema();
                }
            });
            builder.add((UiComponent)this.externalField, cc.xy(5, y));
            builder.add((UiComponent)externalButton, cc.xy(7, y));
            builder.add((UiComponent)soaBrowserButton, cc.xy(9, y));
            if (this.baseObject == null) {
                this.basedOnCheckBox.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent e) {
                        externalButton.setEnabled(ObjectContainerDialog.this.basedOnCheckBox.isSelected());
                        soaBrowserButton.setEnabled(ObjectContainerDialog.this.basedOnCheckBox.isSelected());
                    }
                });
            } else {
                XObjectTypeDescription bpmObject = this.baseObject.getDelegate().asBpmObject();
                ComponentCatalog catalog = bpmObject.getCatalog();
                String schemaId = bpmObject.getProperty("attributes.schema.id");
                TypeDescription baseXml = catalog.findById(ComponentType.XML, schemaId).get();
                String xmlTypeName = baseXml.getText();
                this.nameField.setText(baseXml.getName());
                try {
                    CatalogObject catalogObject = this.project.findCatalogObject(xmlTypeName);
                    this.externalField.setText(xmlTypeName);
                    this.externalSchema = catalogObject;
                    this.basedOnCheckBox.setEnabled(false);
                    this.basedOnCheckBox.setRequestFocusEnabled(false);
                    externalButton.setEnabled(false);
                    soaBrowserButton.setEnabled(false);
                }
                catch (AmbiguousTypeNameException e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
        }
        this.getContentPane().add((UiComponent)container, (Object)"Center");
        this.pack();
        this.setLocationRelativeTo((UiComponent)this.getParent());
        this.nameField.requestFocus();
    }

    private void showErrorMessage(Msg msg) {
        MessageDialog.showError((Msg)UIMsg.TO_MSG((String)this.getTitle()), (Msg)msg);
    }
}

