/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.net.URI;
import java.net.URISyntaxException;
import oracle.bpm.designer.activitiespanels.FeatureEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.project.model.features.NamespaceFeature;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.text.TextField;

public class NamespaceFeatureEditor
extends FeatureEditor<NamespaceFeature> {
    private TextField namespaceTextField;

    public NamespaceFeatureEditor(UiContainer parent, NamespaceFeature feature) {
        super(parent, feature);
        this.build();
    }

    @Override
    public void toFeature() {
        ((NamespaceFeature)this.getFeature()).setValue(this.namespaceTextField.getText());
    }

    @Override
    public void fromFeature() {
        this.namespaceTextField.setText(((NamespaceFeature)this.getFeature()).getValue());
    }

    public void checkValues() throws URISyntaxException {
        if ("".equals(this.namespaceTextField.getText().trim())) {
            throw new URISyntaxException("", "Invalid URI");
        }
        new URI(this.namespaceTextField.getText());
    }

    public void setNamespace(String s) {
        this.namespaceTextField.setText(s);
    }

    private void build() {
        this.setBorder(BorderFactory.createTitledBorder((Border)BorderFactory.createLineBorder((Color)Color.BLACK), (String)DesignerMsg.SERVICE_INFO.getString()));
        this.setLayout((Layout)new MigLayout("fillx"));
        this.namespaceTextField = new TextField((UiContainer)this);
        Label namespace = Label.create((UiContainer)this, (Msg)DesignerMsg.NAMESPACE);
        this.add((UiComponent)namespace);
        this.add((UiComponent)this.namespaceTextField, "growx");
    }
}

