/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.adapter.Adaptable;
import oracle.bpm.designer.DesignerMode;
import oracle.bpm.designer.ModelContainerTreeNode;
import oracle.bpm.designer.ProjectNavigatorTree;
import oracle.bpm.designer.action.DeleteObjectAction;
import oracle.bpm.designer.action.NewModelAction;
import oracle.bpm.designer.action.NewModelContainerAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.extensionpoint.metadata.ActionGroupMetadata;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.ActionGroupFactory;
import oracle.bpm.ui.action.BaseAction;

@ActionGroupMetadata(target=ModelContainerTreeNode.class)
public class ModelContainerActionsFactory
implements ActionGroupFactory {
    public ActionGroup create(Adaptable context) {
        ActionGroup actionGroup = new ActionGroup(DesignerMsg.PROPERTIES, DesignerMode.getCurrentMode().getActionValidator());
        ProjectNavigatorTree mainTree = ProjectNavigatorTree.getMainTree();
        ProjectObject object = context.as(ProjectObject.class);
        if (!mainTree.getShowMenues()) {
            actionGroup.add((BaseAction)new NewModelContainerAction());
        } else {
            ActionGroup newActions = new ActionGroup(DesignerMsg.NEW, DesignerMode.getCurrentMode().getActionValidator());
            actionGroup.add((BaseAction)newActions);
            newActions.add((BaseAction)new NewModelAction());
            newActions.add((BaseAction)new NewModelContainerAction());
            if (object.isDeletable()) {
                actionGroup.add((BaseAction)new DeleteObjectAction(object));
            }
            actionGroup.addSeparator();
        }
        return actionGroup;
    }
}

