/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.Locale;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;

public enum MemberModifiers implements I18nProvider
{
    INSTANCE_ATTRIBUTE(DesignerMsg.INSTANCE_ATTRIBUTE, 1),
    CALCULATED(DesignerMsg.CALCULATED_MEMBER, 2),
    PRIVATE(DesignerMsg.PRIVATE_MEMBER, 4),
    STATIC_ATTRIBUTE(DesignerMsg.STATIC_ATTRIBUTE, 8),
    CAN_READ(DesignerMsg.ATTRIBUTE_READ, 16),
    CAN_WRITE(DesignerMsg.ATTRIBUTE_WRITE, 32),
    INSTANCE_METHOD(DesignerMsg.INSTANCE_METHOD, 64),
    STATIC_METHOD(DesignerMsg.STATIC_METHOD, 128),
    SERVER_SIDE(DesignerMsg.SERVER_SIDE, 1025),
    CLIENT_SIDE(DesignerMsg.CLIENT_SIDE, 2048),
    INHERITED(DesignerMsg.INHERITED, 4096),
    PUBLIC(DesignerMsg.PUBLIC_MEMBER, 16384),
    DEPRECATED(DesignerMsg.DEPRECATED, 32768);

    private transient Msg msg;
    private int mod;

    private MemberModifiers(Msg msg, int mod) {
        this.msg = msg;
        this.mod = mod;
    }

    @Override
    public String getString() {
        return this.getMsg().getString();
    }

    @Override
    public String getString(Locale locale) {
        return this.getMsg().getString(locale);
    }

    public Msg getMsg() {
        return this.msg;
    }

    public int getMod() {
        return this.mod;
    }

    public boolean isIn(long modifiers) {
        return (modifiers & (long)this.getMod()) != 0L;
    }
}

