/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import oracle.bpm.designer.DesignerApplication;
import oracle.bpm.log.Log;
import oracle.bpm.ui.UiUtilities;

class ListenClient
extends Thread {
    Socket client;
    ServerSocket server;
    private String[] files = null;
    private ObjectInputStream input = null;
    private ObjectOutputStream out = null;
    private String question = null;

    public ListenClient(ServerSocket s, Socket c) {
        this.server = s;
        this.client = c;
    }

    @Override
    public void run() {
        try {
            this.input = new ObjectInputStream(this.client.getInputStream());
            this.question = (String)this.input.readObject();
            if (this.question.equals("DESIGNER")) {
                this.out = new ObjectOutputStream(this.client.getOutputStream());
                this.out.writeObject("DESIGNER");
                this.out.flush();
            }
            if (this.question.equals("CLOSE")) {
                ListenClient.finalizeClient(this.client);
                ListenClient.finalizeServer(this.server);
                return;
            }
        }
        catch (IOException e) {
            Log.logInfo(e);
            ListenClient.finalizeClient(this.client);
            ListenClient.finalizeServer(this.server);
            return;
        }
        catch (ClassNotFoundException e) {
            Log.logInfo(e);
            ListenClient.finalizeClient(this.client);
            ListenClient.finalizeServer(this.server);
            return;
        }
        try {
            this.files = (String[])this.input.readObject();
            final DesignerApplication application = DesignerApplication.getInstance();
            while (!application.isVisible()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            if (application.getState() == 1) {
                application.setState(0);
            }
            UiUtilities.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (ListenClient.this.files.length == 0) {
                        application.toFront();
                        application.repaint();
                    }
                }
            });
        }
        catch (IOException e) {
            Log.logInfo(e);
            ListenClient.finalizeClient(this.client);
            ListenClient.finalizeServer(this.server);
            return;
        }
        catch (ClassNotFoundException e) {
            Log.logInfo(e);
            ListenClient.finalizeClient(this.client);
            ListenClient.finalizeServer(this.server);
            return;
        }
        ListenClient.finalizeClient(this.client);
    }

    static synchronized void finalizeClient(Socket client) {
        try {
            client.close();
        }
        catch (IOException e) {
            Log.logInfo(e);
        }
    }

    static synchronized void finalizeServer(ServerSocket server) {
        try {
            server.close();
        }
        catch (IOException e) {
            Log.logInfo(e);
        }
    }
}

