/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.features.ProcessLayoutFeature;
import oracle.bpm.project.model.processes.ProcessLayoutOrientation;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.RelativeLayout;

public abstract class LanesOrientationPanel
extends Panel {
    private boolean dirty;
    private RadioButton<ProcessLayoutOrientation> horizontalOrientation;
    private final Msg message;
    private RadioButton<ProcessLayoutOrientation> undefinedOrientation;
    private RadioButton<ProcessLayoutOrientation> verticalOrientation;

    public LanesOrientationPanel(UiContainer parent, Msg title, Msg message) {
        super(parent, title);
        this.message = message;
        this.build();
    }

    public static LanesOrientationPanel create(Panel parent, final ProcessLayoutFeature feature) {
        return new LanesOrientationPanel((UiContainer)parent, DesignerMsg.LANE_LAYOUT, null){

            @Override
            protected void setLanesOrientation(ProcessLayoutOrientation lanesOrientation) {
                feature.setValue((Enum)lanesOrientation);
            }

            @Override
            protected ProcessLayoutOrientation getOrientation() {
                return (ProcessLayoutOrientation)feature.getValue();
            }
        };
    }

    public void toPreferences() {
        ProcessLayoutOrientation orienation = ProcessLayoutOrientation.HORIZONTAL_LAYOUT;
        if (this.verticalOrientation.isSelected()) {
            orienation = ProcessLayoutOrientation.VERTICAL_LAYOUT;
        } else if (this.undefinedOrientation.isSelected()) {
            orienation = ProcessLayoutOrientation.UNDEFINED_LAYOUT;
        }
        this.setLanesOrientation(orienation);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.horizontalOrientation.setEnabled(enabled);
        this.verticalOrientation.setEnabled(enabled);
        this.undefinedOrientation.setEnabled(enabled);
    }

    protected abstract void setLanesOrientation(ProcessLayoutOrientation var1);

    protected abstract ProcessLayoutOrientation getOrientation();

    private void build() {
        RelativeLayout layout = new RelativeLayout();
        this.setLayout((Layout)layout);
        Panel radioButtons = new Panel((UiContainer)this);
        radioButtons.setLayout((Layout)new FlowLayout(0, 5, 0));
        this.horizontalOrientation = new RadioButton((UiContainer)radioButtons, DesignerMsg.HORIZONTAL);
        this.verticalOrientation = new RadioButton((UiContainer)radioButtons, DesignerMsg.VERTICAL);
        this.undefinedOrientation = new RadioButton((UiContainer)radioButtons, DesignerMsg.UNDEFINED);
        radioButtons.add(this.horizontalOrientation);
        radioButtons.add(this.verticalOrientation);
        radioButtons.add(this.undefinedOrientation);
        ButtonGroup group = new ButtonGroup();
        group.add(this.horizontalOrientation);
        group.add(this.verticalOrientation);
        group.add(this.undefinedOrientation);
        ItemListener dirtyListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                LanesOrientationPanel.this.setDirty(true);
            }
        };
        this.horizontalOrientation.addItemListener(dirtyListener);
        this.verticalOrientation.addItemListener(dirtyListener);
        this.undefinedOrientation.addItemListener(dirtyListener);
        switch (this.getOrientation()) {
            case HORIZONTAL_LAYOUT: {
                this.horizontalOrientation.setSelected(true);
                break;
            }
            case VERTICAL_LAYOUT: {
                this.verticalOrientation.setSelected(true);
                break;
            }
            case UNDEFINED_LAYOUT: {
                this.undefinedOrientation.setSelected(true);
            }
        }
        if (this.message != null) {
            LabelMultiline lanesOrientationTextArea = new LabelMultiline((UiContainer)this, this.message);
            this.add((UiComponent)lanesOrientationTextArea, "lanesOrientation");
        }
        this.add((UiComponent)radioButtons, "radioButtons");
        oracle.bpm.ui.utils.Layout.fixTopDown((RelativeLayout)layout, (String[])new String[]{"lanesOrientation", "radioButtons"});
    }
}

