/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import oracle.bpm.designer.dialog.DesignerDialogFactory;
import oracle.bpm.designer.dialog.organization.AbstractOrganizationDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.organization.RoleDynamicName;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.EditionDialog;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;

public class LaneNameDialog
extends EditionDialog {
    protected ItemListener itemListener;
    protected ComboBox<DataObject> paramVariableComboBox;
    private boolean includeAutomatic;
    private boolean includeParametric = true;
    private Lane lane;
    private String name;
    private RoleDynamicName nameField;
    private String paramVariable;
    private Process process;

    public LaneNameDialog(UiWindow parent, Lane lane, boolean includeAutomatic) {
        this(parent, lane.getProcess(), includeAutomatic, lane);
    }

    public LaneNameDialog(UiWindow parent, Process process, boolean includeAutomatic, Lane lane) {
        this(parent, process, includeAutomatic, true, lane);
    }

    public LaneNameDialog(UiWindow parent, Process process, boolean includeAutomatic, boolean includeParametric, Lane lane) {
        super(parent, DesignerMsg.ROLE_PROPERTIES);
        this.process = process;
        this.lane = lane;
        this.includeAutomatic = includeAutomatic;
        this.includeParametric = includeParametric;
        this.init();
    }

    public void cancel() {
        this.name = null;
        super.cancel();
    }

    public Process getModel() {
        return this.process;
    }

    public String getLaneName() {
        return this.name;
    }

    public String getParamVariable() {
        return this.paramVariable;
    }

    public void ok() {
        String laneName = this.nameField.getName();
        if (laneName == null || "".equals(laneName)) {
            MessageDialog.showError((Msg)DesignerMsg.INVALID_NAME, (Msg)DesignerMsg.ROLE_NAME_NOT_EMPTY);
            return;
        }
        this.paramVariable = this.paramVariableComboBox.isEnabled() && this.paramVariableComboBox.getSelectedItem() != null ? ((DataObject)this.paramVariableComboBox.getSelectedItem()).getName() : null;
        this.synchronizeLanes();
        this.setObjectName(laneName);
        this.close();
    }

    private void synchronizeLanes() {
        for (Lane currentLane : this.getModel().getLanes()) {
            if (!currentLane.getId().equals(this.nameField.getName())) continue;
            currentLane.setParamName(this.paramVariable);
        }
    }

    private RoleDynamicName createInput(UiContainer parent) {
        return new RoleDynamicName(parent, this.getModel(), this.includeAutomatic, this.includeParametric);
    }

    private void setObjectName(String name) {
        this.name = name;
    }

    private void init() {
        RelativeLayout layout = new RelativeLayout();
        Panel container = new Panel(this.getContentPane(), UIMsg.NAME);
        container.setLayout((Layout)layout);
        this.nameField = this.createInput((UiContainer)container);
        Button newButton = new Button((UiContainer)container, DesignerMsg.NEW);
        newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractOrganizationDialog<Role> dialog = DesignerDialogFactory.createRoleDialog((UiWindow)LaneNameDialog.this, LaneNameDialog.this.getModel().getProject().getOrganization());
                dialog.setVisible(true);
                if (dialog.userAccepted()) {
                    LaneNameDialog.this.nameField.updateNames(((Role)dialog.getProjectObjectAdded()).getId());
                }
            }
        });
        Panel paramPanel = new Panel((UiContainer)container, DesignerMsg.PARAM_VARIABLE);
        paramPanel.setLayout((Layout)new BorderLayout());
        this.paramVariableComboBox = UiFactory.createComboBox((UiContainer)paramPanel, this.createParamVariablesList());
        paramPanel.add(this.paramVariableComboBox, (Object)"Center");
        this.itemListener = new RoleItemListener();
        this.nameField.addItemListener(this.itemListener);
        if (this.lane != null) {
            DataObject item;
            this.nameField.updateNames(this.lane.getId());
            if (!Str.isEmpty(this.lane.getParamName()) && (item = this.lane.getProcess().findDataObject(this.lane.getParamName())) == null) {
                item = this.lane.getProject().findDataObject(this.lane.getParamName());
                this.paramVariableComboBox.setSelectedItem((Object)item);
            }
        }
        container.add(this.nameField.getUiComponent(), (Object)"nameCombo");
        container.add((UiComponent)newButton, (Object)"newButton");
        container.add((UiComponent)paramPanel, (Object)"paramPanel");
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"nameCombo", (AttributeType)AttributeType.LEFT, (int)5);
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)"nameCombo", (AttributeType)AttributeType.RIGHT, (String)"newButton", (AttributeType)AttributeType.LEFT, (int)-5);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"nameCombo", (AttributeType)AttributeType.TOP, (int)5);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"newButton", (AttributeType)AttributeType.TOP, (int)5);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"newButton", (AttributeType)AttributeType.RIGHT, (int)-5);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"paramPanel", (AttributeType)AttributeType.LEFT, (int)5);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"paramPanel", (AttributeType)AttributeType.RIGHT, (int)-5);
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)"paramPanel", (AttributeType)AttributeType.TOP, (String)"nameCombo", (AttributeType)AttributeType.BOTTOM, (int)5);
        this.getContentPane().add((UiComponent)container, (Object)"Center");
        this.updateVariablesCombo();
        this.setSize(400, 250);
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private List<DataObject> createParamVariablesList() {
        TreeMap<String, DataObject> sortedParamVariablesMap = new TreeMap<String, DataObject>();
        Process m = this.getModel();
        for (DataObject dataObject : m.getDataObjects()) {
            if (!dataObject.getType().isString()) continue;
            sortedParamVariablesMap.put(dataObject.getId(), dataObject);
        }
        return new ArrayList<DataObject>(sortedParamVariablesMap.values());
    }

    private void updateVariablesCombo() {
        Role role = this.nameField.getName() != null ? this.getModel().getProject().getOrganization().findRoleById(this.nameField.getName()) : null;
        this.paramVariableComboBox.setEnabled(role != null && role.isParametric());
    }

    private class RoleItemListener
    implements ItemListener {
        private RoleItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            LaneNameDialog.this.updateVariablesCombo();
        }
    }
}

