/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import oracle.bpm.designer.MemberModifiers;
import oracle.bpm.designer.catalog.tree.CatalogNodeLoader;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.project.model.CompositeServiceType;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.ComponentRenderer;
import oracle.bpm.type.TypeInfo;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.ui.ComposedIcon;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;
import org.jetbrains.annotations.Nullable;

public class IconFactory {
    private static Map<Integer, Image> memberIconsByKind = new HashMap<Integer, Image>();

    public static Image getIconFor(@Nullable TypeRef typeRef) {
        Image result = null;
        if (typeRef == null || typeRef.getCatalog() == null) {
            result = Image.create((Msg)UIMsg.ERROR);
        } else if (typeRef instanceof MethodTypeDescription) {
            result = IconFactory.getIconFor((MethodTypeDescription)typeRef);
        }
        if (result == null) {
            ComponentRenderer renderer;
            assert (typeRef != null);
            ComponentCatalog catalog = typeRef.getCatalog();
            TypeInfo info = catalog.getInfo(typeRef);
            String componentType = info != null ? info.getType() : typeRef.get().getComponentType();
            long modifs = typeRef.getModifiers();
            result = componentType.equals(ComponentType.OBJECT.getText()) ? Image.create((Msg)DesignerMsg.MODULE) : (Modifier.isException(modifs) ? Image.create((Msg)DesignerMsg.EXCEPTION) : (ComponentType.ENUMERATION.getText().equals(componentType) ? Image.create((Msg)DesignerMsg.ENUM) : ((renderer = ComponentRenderer.Extension.find(componentType)) != null ? Image.create((Msg)renderer.getIcon(typeRef)) : Image.create((Msg)DesignerMsg.COMPONENT))));
            if (IconFactory.isReadOnly(typeRef) || Modifier.isSynthesized(modifs)) {
                result = oracle.bpm.designer.utils.IconFactory.createReadOnly(result);
            }
        }
        return result;
    }

    public static Image getIconFor(MethodTypeDescription member) {
        return IconFactory.getIconFor(member, 0L);
    }

    public static Image getIconFor(CompositeServiceType type) {
        if (type == null) {
            return Image.create((Msg)UIMsg.ERROR);
        }
        return Image.create((Msg)type.getLabel());
    }

    public static Image getIconFor(XFormPresentationModel presentationModel, XObjectTypeDescription object) {
        return IconFactory.isDefault(presentationModel, object) ? Image.create((Msg)DesignerMsg.DEFAULT_PRESENTATION) : Image.create((Msg)DesignerMsg.PRESENTATION);
    }

    public static Image getIconFor(MethodTypeDescription member, long modifiers) {
        Image currentValue;
        if (member == null || !member.isAttribute() && !member.isMethod()) {
            return null;
        }
        long memberModifiers = member.getModifiers();
        int kind = 0;
        if (member.isAttribute()) {
            kind |= Modifier.isStatic(memberModifiers) ? MemberModifiers.STATIC_ATTRIBUTE.getMod() : MemberModifiers.INSTANCE_ATTRIBUTE.getMod();
            if (member.asAttribute().isCalculated()) {
                kind |= MemberModifiers.CALCULATED.getMod();
            }
            if (Modifier.hasGetter(memberModifiers)) {
                kind |= MemberModifiers.CAN_READ.getMod();
            }
            if (Modifier.hasSetter(memberModifiers)) {
                kind |= MemberModifiers.CAN_WRITE.getMod();
            }
        } else if (member.isMethod()) {
            kind |= Modifier.isStatic(memberModifiers) ? MemberModifiers.STATIC_METHOD.getMod() : MemberModifiers.INSTANCE_METHOD.getMod();
            if (Modifier.isInherited(memberModifiers) || Modifier.isDelegated(memberModifiers) || Modifier.isInherited(modifiers) || Modifier.isDelegated(modifiers)) {
                kind |= MemberModifiers.INHERITED.getMod();
            }
            kind = Modifier.isServer(memberModifiers) ? (kind |= MemberModifiers.SERVER_SIDE.getMod()) : (kind |= MemberModifiers.CLIENT_SIDE.getMod());
        }
        kind = Modifier.isPrivate(memberModifiers) ? (kind |= MemberModifiers.PRIVATE.getMod()) : (kind |= MemberModifiers.PUBLIC.getMod());
        if (Modifier.isDeprecated(modifiers) || Modifier.isDeprecated(memberModifiers)) {
            kind |= MemberModifiers.DEPRECATED.getMod();
        }
        if ((currentValue = memberIconsByKind.get(kind)) == null) {
            ArrayList<Image> iconList = new ArrayList<Image>();
            for (MemberModifiers eachMod : MemberModifiers.values()) {
                Image icon;
                if (!eachMod.isIn(kind) || (icon = Image.create((Msg)eachMod.getMsg())) == null) continue;
                iconList.add(icon);
            }
            currentValue = Image.create((Icon)new ComposedIcon(iconList));
            if (MemberModifiers.DEPRECATED.isIn(kind)) {
                currentValue = oracle.bpm.designer.utils.IconFactory.createGreyIcon(currentValue);
            }
            memberIconsByKind.put(kind, currentValue);
        }
        return currentValue;
    }

    public static boolean isDefault(XFormPresentationModel model, XObjectTypeDescription object) {
        String name = object.getDefaultPresentationName();
        return name != null && name.equals(model.getModelName());
    }

    private static boolean isReadOnly(TypeRef object) {
        return TypeUtils.belongsToDefaultCatalog(object) || CatalogNodeLoader.getCatalogObjectModel(object).isReadOnly();
    }
}

