/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.action.SnapToGridAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.text.NumericField;

public class GridPropertiesDialog
extends OkCancelDialog {
    private NumericField<Integer> gridSizeField;

    public GridPropertiesDialog(UiWindow parent) {
        super(parent, DesignerMsg.GRIDSETUP, true);
        this.setResizable(false);
        this.construct();
    }

    public void ok() {
        DesignerPreferences designerPreferences = DesignerPreferences.getPreferences();
        designerPreferences.setGridSize((Integer)this.gridSizeField.getValue());
        designerPreferences.store();
        boolean snapToGrid = designerPreferences.getSnapToGrid();
        if (snapToGrid) {
            SnapToGridAction.snapToGrid();
        }
        AbstractStudioWorkbench.repaintAllDesigns();
        this.close();
    }

    private void construct() {
        Panel container = new Panel(this.getContentPane());
        this.getContentPane().setLayout((Layout)new BorderLayout());
        this.gridSizeField = NumericField.createIntegerNumericField((UiContainer)container, (boolean)true);
        this.gridSizeField.setColumns(5);
        this.gridSizeField.setFieldEnabled(false);
        this.gridSizeField.setRange((Number)12, (Number)48);
        this.gridSizeField.setStepSize((Number)4);
        this.gridSizeField.setValue((Number)DesignerPreferences.getPreferences().getGridSize().get());
        String colSpecs = "15dlu, left:p:grow,15dlu, right:p:grow, 10dlu";
        String rowSpecs = "15dlu, p, 10dlu";
        FormLayout layout = new FormLayout(colSpecs, rowSpecs);
        PanelBuilder builder = layout.createBuilder(container);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)Label.create((UiContainer)container, (Msg)DesignerMsg.GRIDSIZE), cc.xy(2, 2));
        builder.add(this.gridSizeField, cc.xy(4, 2));
        this.getContentPane().add((UiComponent)container, (Object)"Center");
        this.pack();
        this.setLocationRelativeTo((UiComponent)this.getParent());
        this.gridSizeField.requestFocus();
    }
}

