/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.designer.activitiespanels.FeatureEditor;
import oracle.bpm.project.model.features.GreedyExecutionModeFeature;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;

public class GreedyExecutionFeatureEditor
extends FeatureEditor<GreedyExecutionModeFeature> {
    private RadioButton defaultRadio;
    private RadioButton disableRadio;
    private RadioButton enableRadio;

    public GreedyExecutionFeatureEditor(UiContainer parent, GreedyExecutionModeFeature feature) {
        super(parent, feature);
        this.build();
    }

    @Override
    public void toFeature() {
        if (this.defaultRadio.isSelected()) {
            ((GreedyExecutionModeFeature)this.getFeature()).setValue("default");
        } else if (this.enableRadio.isSelected()) {
            ((GreedyExecutionModeFeature)this.getFeature()).setValue("true");
        } else {
            ((GreedyExecutionModeFeature)this.getFeature()).setValue("false");
        }
    }

    @Override
    public void fromFeature() {
        String featureValue = ((GreedyExecutionModeFeature)this.getFeature()).getValue();
        if (featureValue.equals("default")) {
            this.defaultRadio.setSelected(true);
        } else if (featureValue.equals("true")) {
            this.enableRadio.setSelected(true);
        } else {
            this.disableRadio.setSelected(true);
        }
    }

    private void build() {
        this.setLayout((Layout)new BorderLayout(5, 5));
        Panel radioPanel = new Panel((UiContainer)this);
        ButtonGroup group = new ButtonGroup();
        this.defaultRadio = new RadioButton((UiContainer)radioPanel, ProjectModelMsg.USE_DEFAULT);
        this.enableRadio = new RadioButton((UiContainer)radioPanel, ProjectModelMsg.GREEDY_EXECUTION_MODE_ENABLE);
        this.disableRadio = new RadioButton((UiContainer)radioPanel, ProjectModelMsg.GREEDY_EXECUTION_MODE_DISABLE);
        group.add((AbstractButton)this.defaultRadio);
        group.add((AbstractButton)this.enableRadio);
        group.add((AbstractButton)this.disableRadio);
        UiUtilities.layoutRadioButtonPanel((UiContainer)radioPanel, null, (RadioButton[])new RadioButton[]{this.defaultRadio, this.enableRadio, this.disableRadio}, (boolean)false);
        this.add((UiComponent)radioPanel, "Center");
    }
}

