/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.designer.activitiespanels.FeatureEditor;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.processes.ProcessGenerateEvents;
import oracle.bpm.project.model.processes.activities.ProcessGenerateEventsFeature;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;

public class GenerateEventFeatureEditor
extends FeatureEditor<ProcessGenerateEventsFeature> {
    private RadioButton allActivitiesRadio;
    private RadioButton interactiveRadio;
    private RadioButton noEventsRadio;
    private RadioButton projectDefaultRadio;

    public GenerateEventFeatureEditor(UiContainer parent, ProcessGenerateEventsFeature feature) {
        super(parent, feature);
        this.build();
    }

    @Override
    public void toFeature() {
        if (this.interactiveRadio.isSelected()) {
            ((ProcessGenerateEventsFeature)this.getFeature()).setValue((Enum)ProcessGenerateEvents.GENERATE_INTERACTIVE_EVENTS);
        } else if (this.allActivitiesRadio.isSelected()) {
            ((ProcessGenerateEventsFeature)this.getFeature()).setValue((Enum)ProcessGenerateEvents.GENERATE_ALL_EVENTS);
        } else if (this.noEventsRadio.isSelected()) {
            ((ProcessGenerateEventsFeature)this.getFeature()).setValue((Enum)ProcessGenerateEvents.DO_NOT_GENERATE_EVENTS);
        } else {
            ((ProcessGenerateEventsFeature)this.getFeature()).setValue((Enum)ProcessGenerateEvents.PROJECT_DEFAULT);
        }
    }

    @Override
    public void fromFeature() {
        ProcessGenerateEvents featureValue = (ProcessGenerateEvents)((ProcessGenerateEventsFeature)this.getFeature()).getValue();
        switch (featureValue) {
            case DO_NOT_GENERATE_EVENTS: {
                this.noEventsRadio.setSelected(true);
                break;
            }
            case GENERATE_ALL_EVENTS: {
                this.allActivitiesRadio.setSelected(true);
                break;
            }
            case GENERATE_INTERACTIVE_EVENTS: {
                this.interactiveRadio.setSelected(true);
                break;
            }
            case PROJECT_DEFAULT: {
                this.projectDefaultRadio.setSelected(true);
            }
        }
    }

    private void build() {
        this.setLayout((Layout)new BorderLayout(5, 5));
        Panel radioPanel = new Panel((UiContainer)this);
        ButtonGroup group = new ButtonGroup();
        this.projectDefaultRadio = new RadioButton((UiContainer)radioPanel, ProcessGenerateEvents.PROJECT_DEFAULT.getMsg());
        this.projectDefaultRadio.setSelected(true);
        this.allActivitiesRadio = new RadioButton((UiContainer)radioPanel, DesignerMsg.GENERATE_EVENTS_ALL_ACTIVITIES);
        this.interactiveRadio = new RadioButton((UiContainer)radioPanel, DesignerMsg.GENERATE_EVENTS_INTERACTIVE_ACTIVITIES);
        this.noEventsRadio = new RadioButton((UiContainer)radioPanel, DesignerMsg.DO_NOT_GENERATE_EVENTS);
        group.add((AbstractButton)this.projectDefaultRadio);
        group.add((AbstractButton)this.allActivitiesRadio);
        group.add((AbstractButton)this.interactiveRadio);
        group.add((AbstractButton)this.noEventsRadio);
        UiUtilities.layoutRadioButtonPanel((UiContainer)radioPanel, null, (RadioButton[])new RadioButton[]{this.projectDefaultRadio, this.interactiveRadio, this.allActivitiesRadio, this.noEventsRadio}, (boolean)false);
        this.add((UiComponent)radioPanel, "Center");
    }
}

