/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.awt.event.MouseWheelListener;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.Domain;
import oracle.bpm.designer.processdesigner.DomainKeyboardManager;
import oracle.bpm.designer.processdesigner.DomainMouseManager;
import oracle.bpm.designer.processdesigner.states.AbstractDesignerState;
import oracle.bpm.designer.processdesigner.states.PointerState;
import oracle.bpm.geom.Point;
import oracle.bpm.project.compile.exceptions.InvalidLocationForObjectException;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.event.MouseMotionListener;
import org.jetbrains.annotations.NotNull;

public class DomainStateManager {
    private boolean controlPressed;
    private boolean shiftPressed;
    private AbstractDesignerState currentState;
    private Domain domain;
    private final DomainKeyboardManager keyBoardManager;
    private final DomainMouseManager mouseManager;
    public static final int SELECTION_STRING_LENGTH = 6;

    public DomainStateManager(@NotNull Domain domain) {
        this.domain = domain;
        this.keyBoardManager = new DomainKeyboardManager(this);
        this.mouseManager = new DomainMouseManager(this);
        domain.getCanvas().addKeyListener(this.keyBoardManager.getKeyListener());
        domain.getCanvas().addMouseListener((MouseListener)this.mouseManager);
        domain.getCanvas().addMouseWheelListener((MouseWheelListener)this.mouseManager);
        domain.getCanvas().addMouseMotionListener((MouseMotionListener)this.mouseManager);
        this.setDefaultState();
    }

    public static void checkDropLocation(Point p, FlowElement activity) throws InvalidLocationForObjectException {
        if (p.getY() < 25 || p.getX() < 25) {
            throw new InvalidLocationForObjectException(activity);
        }
    }

    public void setControlPressed(boolean controlPressed) {
        this.controlPressed = controlPressed;
    }

    public void setShiftPressed(boolean shiftPressed) {
        this.shiftPressed = shiftPressed;
    }

    public void checkAutoScrolling(int x, int y) {
    }

    public Domain getDomain() {
        return this.domain;
    }

    public boolean isSimulating() {
        return AbstractStudioWorkbench.getInstance().isSimulating();
    }

    public void repaint() {
        this.getDomain().getCanvas().repaint();
    }

    public void setCurrentState(AbstractDesignerState state) {
        state.setStateManager(this);
        this.currentState = state;
        state.init();
    }

    public AbstractDesignerState getCurrentState() {
        return this.currentState;
    }

    public void setDefaultState() {
        this.setCurrentState(new PointerState());
    }

    public void enableCancelAddingEvent() {
    }

    public void disableCancelAddingEvent() {
    }

    public boolean isShiftPressed() {
        return this.shiftPressed;
    }

    public boolean isControlPressed() {
        return this.controlPressed;
    }
}

