/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.draw.Color;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.ui.ModelObjectSelection;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.utils.ColorUtils;

public final class DesignerUtils {
    private DesignerUtils() {
    }

    public static FlowNode getLastActivity(ModelObjectSelection activities) {
        FlowNode result = null;
        for (FlowNode flowNode : activities.getActivities()) {
            boolean shouldHaveOutgoingTransitions = ModelUtils.shouldHaveOutgoingSequenceFlow((FlowNode)flowNode);
            if (!shouldHaveOutgoingTransitions) continue;
            Sequence transitions = activities.getTransitions();
            boolean found = false;
            if (transitions != null) {
                for (SequenceFlow transition : transitions) {
                    if (!ModelUtils.isEndEvent((FlowNode)transition.getSource()) || flowNode != transition.getTarget()) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            result = flowNode;
            break;
        }
        return result;
    }

    public static FlowNode getFirstActivity(ModelObjectSelection activities) {
        FlowNode result = null;
        for (FlowNode flowNode : activities.getActivities()) {
            if (ModelUtils.isStartOrEndEvent((FlowNode)flowNode)) continue;
            Sequence transitions = activities.getTransitions();
            boolean found = false;
            if (transitions != null) {
                for (SequenceFlow transition : transitions) {
                    if (!ModelUtils.isStartEvent((FlowNode)transition.getSource()) || flowNode != transition.getTarget()) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            result = flowNode;
            break;
        }
        return result;
    }

    public static List<SequenceFlow> getIncomingTransitions(ModelObjectSelection objects) {
        ArrayList<SequenceFlow> result = new ArrayList<SequenceFlow>();
        for (FlowNode node : objects.getActivities()) {
            Sequence incomingTransitions = ModelUtils.getIncomingSequenceFlows((FlowNode)node);
            for (SequenceFlow incomingTransition : incomingTransitions) {
                if (objects.containsObject(incomingTransition.getSource())) continue;
                result.add(incomingTransition);
            }
        }
        return result;
    }

    public static Collection<SequenceFlow> getOutgoingTransitions(ModelObjectSelection objects) {
        ArrayList<SequenceFlow> result = new ArrayList<SequenceFlow>();
        for (FlowElement modelObject : objects) {
            if (!(modelObject instanceof FlowNode)) continue;
            FlowNode node = (FlowNode)modelObject;
            Sequence outgoingTransitions = ModelUtils.getOutgoingSequenceFlows((FlowNode)node);
            for (SequenceFlow outgoingTransition : outgoingTransitions) {
                if (objects.containsObject(outgoingTransition.getTarget())) continue;
                result.add(outgoingTransition);
            }
        }
        return result;
    }

    public static boolean setFColor(String strColor, UiComponent component) {
        boolean result;
        Color color = ColorUtils.getColor((String)strColor);
        boolean bl = result = color != null;
        if (result) {
            component.setForeground(color);
        }
        return result;
    }

    public static String getSuggestedName(String suggestedPrefix, Predicate<String> nameExists) {
        int i = 1;
        String suggestedName = DesignerUtils.formatSuggestedPrefix(suggestedPrefix);
        while (nameExists.check(suggestedName)) {
            suggestedName = DesignerUtils.formatSuggestedPrefix(suggestedPrefix) + i;
            ++i;
        }
        return suggestedName;
    }

    private static String formatSuggestedPrefix(String suggestedPrefix) {
        return suggestedPrefix.replaceAll(" ", "_");
    }
}

