/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.designer.StudioPersistenceThread;
import oracle.bpm.designer.ThreadHandler;
import oracle.bpm.designer.preferences.DesignerPreferences;

public class DesignerThreadHandler
implements ThreadHandler {
    private DesignerPreferences preferences = DesignerPreferences.getPreferences();
    private StudioPersistenceThread saveThread;

    public DesignerPreferences getPreferences() {
        return this.preferences;
    }

    public StudioPersistenceThread getStudioPersistenceThread() {
        return this.saveThread;
    }

    @Override
    public void initialize() {
        DesignerPreferences preferences = this.getPreferences();
        this.saveThread = new StudioPersistenceThread(preferences.getSaveDelay());
    }

    @Override
    public void restartAll() {
        DesignerPreferences preferences = this.getPreferences();
        this.internalRestartSaveThread(preferences);
    }

    public void restartSaveThread() {
        this.internalRestartSaveThread(this.getPreferences());
    }

    private void internalRestartSaveThread(DesignerPreferences preferences) {
        if (preferences.isAutoSaveEnabled()) {
            if (this.saveThread != null) {
                this.saveThread.interrupt();
            }
            this.saveThread = new StudioPersistenceThread(preferences.getSaveDelay());
            System.out.println("Starting persistence thread");
            this.saveThread.start();
        } else if (this.saveThread != null && !this.saveThread.isInterrupted()) {
            this.saveThread.interrupt();
        }
    }
}

