/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.List;
import java.util.Locale;
import oracle.bpm.collections.maps.LocaleStringMap;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectPreferences;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.LocalizedMessage;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.text.TextComponent;
import oracle.bpm.ui.text.TextHolder;

public class DesignerResources {
    public static LocalizationButton buildLocalizationButton(Project project, UiContainer parent, LocaleStringMap langMap, TextComponent textComponent, String dialogMessage) {
        return DesignerResources.buildLocalizationButton(project, parent, langMap, textComponent, dialogMessage, false);
    }

    public static LocalizationButton buildLocalizationButton(Project project, UiContainer parent, LocaleStringMap langMap, TextComponent textComponent, String dialogMessage, boolean multilineAllowed) {
        ProjectPreferences preferences = project.getPreferences();
        return DesignerResources.buildLocalizationButton(project, parent, langMap, textComponent, dialogMessage, multilineAllowed, preferences.getAvailableLanguages());
    }

    public static LocalizationButton buildLocalizationButton(Project project, UiContainer parent, final LocaleStringMap langMap, final TextComponent textComponent, String dialogMessage, boolean multilineAllowed, List<Locale> availableLanguages) {
        LocalizationProvider localizationProvider = new LocalizationProvider(){

            @Override
            public LocaleStringMap getLocaleStringMap() {
                return langMap;
            }

            @Override
            public TextHolder getTextHolder() {
                return textComponent;
            }
        };
        return DesignerResources.buildLocalizationButton(project, parent, localizationProvider, dialogMessage, multilineAllowed, availableLanguages);
    }

    public static LocalizationButton buildLocalizationButton(Project project, UiContainer parent, LocalizationProvider langMap, String dialogMessage) {
        return DesignerResources.buildLocalizationButton(project, parent, langMap, dialogMessage, false);
    }

    public static LocalizationButton buildLocalizationButton(Project project, UiContainer parent, LocalizationProvider provider, String dialogMessage, boolean multilineAllowed) {
        ProjectPreferences preferences = project.getPreferences();
        return DesignerResources.buildLocalizationButton(project, parent, provider, dialogMessage, multilineAllowed, preferences.getAvailableLanguages());
    }

    public static LocalizationButton buildLocalizationButton(Project project, final UiContainer parent, final LocalizationProvider provider, final String dialogMessage, final boolean multilineAllowed, final List<Locale> availableLanguages) {
        final LocalizationButton localizedMessageButton = new LocalizationButton(parent, provider);
        final ProjectPreferences preferences = project.getPreferences();
        localizedMessageButton.setEnabled(preferences.getAvailableLanguages().size() > 1);
        localizedMessageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String text;
                Locale defaultLocale = preferences.getDefaultLanguage();
                if (provider.getTextHolder() != null) {
                    localizedMessageButton.getMap().put(defaultLocale, provider.getTextHolder().getText());
                }
                LocalizedMessage.LocalizedDialog dialog = LocalizedMessage.createDialog((UiWindow)parent.getOwnerWindow(), (LocaleStringMap)localizedMessageButton.getMap(), (List)availableLanguages, (boolean)multilineAllowed);
                dialog.setTitle(dialogMessage);
                dialog.setVisible(true);
                if (!dialog.userAccepted()) {
                    return;
                }
                localizedMessageButton.getMap().clear();
                LocaleStringMap resultMap = dialog.getMessages();
                if (resultMap == null) {
                    return;
                }
                for (Locale s : resultMap.keySet()) {
                    localizedMessageButton.getMap().put(s, (String)resultMap.get((Object)s));
                }
                if (provider.getTextHolder() != null && (text = (String)localizedMessageButton.getMap().get((Object)defaultLocale)) != null && !text.equals("")) {
                    provider.getTextHolder().setText(text);
                }
            }
        });
        return localizedMessageButton;
    }

    public static class LocalizationButton
    extends Button {
        private LocaleStringMap map;
        private LocalizationProvider provider;

        public LocalizationButton(UiContainer parent, LocalizationProvider provider) {
            super(parent, DesignerMsg.LOCALIZED_MESSAGE);
            this.provider = provider;
            LocalizationButton.setIconic((Button)this);
        }

        public LocaleStringMap getMap() {
            if (this.map != null) {
                return this.map;
            }
            return this.provider.getLocaleStringMap();
        }

        public void setMap(LocaleStringMap localeStringMap) {
            this.map = localeStringMap;
        }
    }

    public static interface LocalizationProvider {
        public LocaleStringMap getLocaleStringMap();

        public TextHolder getTextHolder();
    }
}

