/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.designer.DesignerMode;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.NewModelSimulationAction;
import oracle.bpm.extensionpoint.metadata.ActionGroupMetadata;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.ActionGroupFactory;
import oracle.bpm.ui.action.BaseAction;

@ActionGroupMetadata(target=Process.class)
public class DesignerProcessActions
implements ActionGroupFactory {
    private static List<BaseAction> convertActions = new ArrayList<BaseAction>();

    public static void addConvertAction(BaseAction action) {
        convertActions.add(action);
    }

    public ActionGroup create(Adaptable context) {
        Process process = context.as(Process.class);
        ActionGroup result = new ActionGroup(DesignerMsg.EDIT, DesignerMode.getCurrentMode().getActionValidator());
        result.addSeparator();
        result.add((BaseAction)new NewModelSimulationAction(process, process.getProject()));
        if (!convertActions.isEmpty()) {
            result.addSeparator();
            ActionGroup exportActionsGroup = new ActionGroup(DesignerMsg.CONVERT);
            for (BaseAction exportAction : convertActions) {
                exportActionsGroup.add(exportAction);
            }
            result.add((BaseAction)exportActionsGroup);
        }
        return result;
    }
}

