/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import oracle.bpm.capability.Capability;
import oracle.bpm.capability.CapabilityListener;
import oracle.bpm.capability.CapabilityService;
import oracle.bpm.designer.DesignerModeListener;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.profile.BusinessAnalystModeConfigurator;
import oracle.bpm.designer.profile.BusinessArchitectModeConfigurator;
import oracle.bpm.designer.profile.DesignerModeConfigurator;
import oracle.bpm.designer.profile.DeveloperModeConfigurator;
import oracle.bpm.designer.profile.PerspectiveLayoutConfigurator;
import oracle.bpm.lang.Platform;
import oracle.bpm.project.model.processes.TransitionType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ActionFilter;
import oracle.bpm.ui.Separator;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.Utilities;

public class DesignerMode {
    private DesignerModeConfigurator designerModeConfigurator;
    private Msg msg_d;
    private int value_d;
    private static boolean listenersEnabled = true;
    public static final int ALL = 65535;
    public static final int BUSINESS_ANALYST = 1;
    public static final int DEVELOPER = 2;
    public static final int BUSINESS_ARCHITECT = 3;
    public static final DesignerMode BUSINESS_ANALYST_MODE = new DesignerMode(DesignerMsg.ANALYST, 1, new BusinessAnalystModeConfigurator());
    public static final DesignerMode BUSINESS_ARCHITECT_MODE = new DesignerMode(DesignerMsg.BUSINESS_ARCHITECT, 3, new BusinessArchitectModeConfigurator());
    public static final DesignerMode DEVELOPER_MODE = new DesignerMode(DesignerMsg.DEVELOPER, 2, new DeveloperModeConfigurator());
    private static DesignerMode currentMode_d = DesignerMode.getDefaultMode();
    private static List<DesignerModeListener> listenerList_d = new ArrayList<DesignerModeListener>();
    private static final String VALUE_PROPERTY = "oracle.bpm.designer.value";

    public DesignerMode(Msg msg, int value, DesignerModeConfigurator designerModeConfigurator) {
        this.msg_d = msg;
        this.value_d = value;
        this.designerModeConfigurator = designerModeConfigurator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setCurrentMode(DesignerMode newMode) {
        if (currentMode_d != newMode) {
            DesignerMode oldMode = currentMode_d;
            currentMode_d = newMode;
            try {
                listenersEnabled = false;
                DesignerMode.fireModeChanged(oldMode, newMode);
                DesignerMode.getCurrentMode().getDesignerModeConfigurator().configure();
            }
            finally {
                listenersEnabled = true;
            }
        }
    }

    public static DesignerMode getCurrentMode() {
        return currentMode_d;
    }

    public static boolean isValid(int mode) {
        int currentMode = DesignerMode.getCurrentMode().value_d;
        return (currentMode & mode) == currentMode;
    }

    public static Boolean isValidComponent(UiComponent comp) {
        Action action;
        Integer valueProperty = null;
        if (comp.isSwing() && comp.asSwing() instanceof AbstractButton && (action = ((AbstractButton)comp.asSwing()).getAction()) != null) {
            valueProperty = (Integer)action.getValue(VALUE_PROPERTY);
        }
        if (valueProperty == null) {
            valueProperty = (Integer)comp.getClientProperty(VALUE_PROPERTY);
        }
        Boolean result = null;
        if (valueProperty != null) {
            result = DesignerMode.isValidMode(valueProperty);
        }
        return result;
    }

    public static void setVisibility(Action action, int value) {
        action.putValue(VALUE_PROPERTY, value);
    }

    public static void setVisibility(UiComponent comp, int value) {
        comp.putClientProperty(VALUE_PROPERTY, (Object)value);
    }

    public static synchronized void addChangeListener(DesignerModeListener listener) {
        listenerList_d.add(listener);
    }

    public static synchronized void removeChangeListener(DesignerModeListener listener) {
        listenerList_d.remove(listener);
    }

    public static void updateComponents(UiComponent comp) {
        DesignerMode.verifyComponent(comp);
        List children = Utilities.getChildrenComponents((UiComponent)comp);
        if (children != null) {
            for (UiComponent child : children) {
                DesignerMode.updateComponents(child);
            }
            DesignerMode.verifySeparators(children);
        }
    }

    public static synchronized void initCapabilityListener() {
        DesignerMode.setFromCapabilities();
        DesignerMode.getDevelopmentCapability().addListener(new CapabilityListener(){

            @Override
            public void capbilityChanged(Capability capability) {
                if (listenersEnabled) {
                    DesignerMode.setFromCapabilities();
                }
            }
        });
        DesignerMode.getBusinessDeveloperCapability().addListener(new CapabilityListener(){

            @Override
            public void capbilityChanged(Capability capability) {
                if (listenersEnabled) {
                    DesignerMode.setFromCapabilities();
                }
            }
        });
    }

    public static Capability getAnalystDocCapability() {
        CapabilityService service = Platform.getCapabilityService();
        return service.findCapability("fuego.studio.help.analyst");
    }

    public static Capability getBusinessDeveloperDocCapability() {
        CapabilityService service = Platform.getCapabilityService();
        return service.findCapability("fuego.studio.help.architect");
    }

    public static Capability getDevelopmentDocCapability() {
        CapabilityService service = Platform.getCapabilityService();
        return service.findCapability("fuego.studio.help.developer");
    }

    public static Capability getDevelopmentCapability() {
        CapabilityService service = Platform.getCapabilityService();
        return service.findCapability("fuego.studio.development");
    }

    public static Capability getBusinessDeveloperCapability() {
        CapabilityService service = Platform.getCapabilityService();
        return service.findCapability("fuego.studio.businessdev");
    }

    public static Capability getALBPMCapability() {
        CapabilityService service = Platform.getCapabilityService();
        return service.findCapability("fuego.studio.albpm");
    }

    public static boolean isDeveloper() {
        return DesignerMode.getCurrentMode().getValue() == 2;
    }

    public static boolean isValid(TransitionType transitionType) {
        boolean result = true;
        int mode = DesignerMode.getCurrentMode().getValue();
        switch (transitionType) {
            case ANY: 
            case COMPENSATE: 
            case MESSAGE_BASED: 
            case DEPENDENCY: {
                result = mode == 2;
                break;
            }
            case CONDITIONAL: 
            case UNCONDITIONAL: 
            case EXCEPTION: 
            case DUE_SCHEDULE: 
            case DUE: {
                result = true;
            }
        }
        return result;
    }

    public static boolean isBusinessAnalyst() {
        return DesignerMode.getCurrentMode().getValue() == 1;
    }

    public static boolean isBusinessArchitect() {
        return DesignerMode.getCurrentMode().getValue() == 3;
    }

    public static DesignerMode getDefaultMode() {
        DEVELOPER_MODE.getDesignerModeConfigurator().configure();
        return DEVELOPER_MODE;
    }

    public ActionFilter getActionValidator() {
        return this.designerModeConfigurator.getActionFilter();
    }

    public Msg getMsg() {
        return this.msg_d;
    }

    public int getValue() {
        return this.value_d;
    }

    public PerspectiveLayoutConfigurator<Object> getPerspectiveLayoutConfigurator() {
        return this.designerModeConfigurator.getPerspectiveLayoutConfigurator();
    }

    protected DesignerModeConfigurator getDesignerModeConfigurator() {
        return this.designerModeConfigurator;
    }

    private static Boolean isValidMode(int value) {
        return DesignerMode.isValid(value) ? Boolean.TRUE : Boolean.FALSE;
    }

    private static void fireModeChanged(DesignerMode oldMode, DesignerMode newMode) {
        for (DesignerModeListener listener : listenerList_d) {
            listener.designerModeChanged(oldMode, newMode);
        }
    }

    private static void verifyComponent(UiComponent comp) {
        Boolean result = DesignerMode.isValidComponent(comp);
        if (result != null) {
            comp.setVisible(result.booleanValue());
        }
    }

    private static void verifySeparators(List<UiComponent> children) {
        boolean existSomePreviousItemVisible = false;
        for (int i = 0; i < children.size(); ++i) {
            if (children.get(i) instanceof Separator) {
                boolean existSomeNextItemVisible = false;
                if (existSomePreviousItemVisible) {
                    for (int j = i + 1; !existSomeNextItemVisible && j < children.size(); ++j) {
                        if (children.get(j) instanceof Separator) continue;
                        existSomeNextItemVisible = children.get(j).isVisible();
                    }
                }
                children.get(i).setVisible(existSomePreviousItemVisible && existSomeNextItemVisible);
                existSomePreviousItemVisible = false;
                continue;
            }
            if (existSomePreviousItemVisible) continue;
            existSomePreviousItemVisible = children.get(i).isVisible();
        }
    }

    private static void setFromCapabilities() {
        if (DesignerMode.getDevelopmentCapability().isEnabled()) {
            DesignerMode.setCurrentMode(DEVELOPER_MODE);
        } else if (DesignerMode.getBusinessDeveloperCapability().isEnabled()) {
            DesignerMode.setCurrentMode(BUSINESS_ARCHITECT_MODE);
        } else {
            DesignerMode.setCurrentMode(BUSINESS_ANALYST_MODE);
        }
    }
}

