/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.io.File;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ModelException;
import oracle.bpm.resources.Msg;

public class DesignerException
extends ModelException {
    static final long serialVersionUID = -3222874149131946605L;
    static final long serialCheck = 2594765073234650594L;

    public DesignerException(Msg message) {
        super(null, message);
    }

    public DesignerException(ProjectObject projectObject, Msg msg) {
        super(projectObject, msg);
    }

    public static DesignerException couldNotCreateProject(File projectDir) {
        return new DesignerException(DesignerMsg.COULD_NOT_CREATE_PROJECT(projectDir.getPath()));
    }

    public static DesignerException couldNotOpenProject(File projectFile) {
        return new DesignerException(DesignerMsg.PROJECT_NOT_FOUND(projectFile.getAbsolutePath()));
    }

    public static DesignerException newProjectBaseDirNotFound(File baseDir) {
        return new DesignerException(DesignerMsg.NEW_PROJECT_BASEDIR_NOT_FOUND(baseDir.getPath()));
    }

    public static DesignerException projectAlreadyExists(File projectDir) {
        return new DesignerException(DesignerMsg.PROJECT_ALREADY_EXISTS(projectDir.getPath()));
    }

    public static DesignerException projectNameAlreadyExists(String projectName) {
        return new DesignerException(DesignerMsg.PROJECT_ALREADY_EXISTS(projectName));
    }
}

