/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.Locale;
import javax.swing.Action;
import oracle.bpm.designer.AppInfo;
import oracle.bpm.designer.Context;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.DesignerMode;
import oracle.bpm.designer.StudioPreferencesDialog;
import oracle.bpm.designer.action.ClosePanelAction;
import oracle.bpm.designer.action.CloseProjectAction;
import oracle.bpm.designer.action.DelegateAction;
import oracle.bpm.designer.action.ExportProjectAction;
import oracle.bpm.designer.action.ImportObjectAction;
import oracle.bpm.designer.action.ImportProjectAction;
import oracle.bpm.designer.action.LaunchPortalAction;
import oracle.bpm.designer.action.ModelActionSet;
import oracle.bpm.designer.action.NewBpmObjectAction;
import oracle.bpm.designer.action.NewBusinessParameterAction;
import oracle.bpm.designer.action.NewEnumerationAction;
import oracle.bpm.designer.action.NewModuleAction;
import oracle.bpm.designer.action.NewProjectAction;
import oracle.bpm.designer.action.ProjectPreferencesAction;
import oracle.bpm.designer.action.ShowComponentIndexAction;
import oracle.bpm.designer.action.UpdateAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.CheckBoxMenuItem;
import oracle.bpm.ui.CustomFuegoAction;
import oracle.bpm.ui.Frame;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Menu;
import oracle.bpm.ui.MenuItem;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.tips.TipOfTheDayFactory;
import oracle.bpm.ui.utils.FrameDecorators;
import oracle.bpm.util.CommonPreferences;
import oracle.bpm.util.Locales;

public class DesignerActions {
    public static BaseAction refreshAction;
    private static Msg applicationNameMsg;
    public static DelegateAction methodListAction;
    public static DelegateAction nextMemberAction;
    public static DelegateAction previousMemberAction;
    public static BaseAction showMessagesAction;
    private static boolean initialized;
    protected static BaseAction newAnythingAction_d;
    protected static BaseAction importEnumerationAction;
    protected static BaseAction importFuegoObjectAction;
    protected static BaseAction openAnythingAction_d;
    public static BaseAction updateAction_d;
    public static BaseAction pageDialogAction_d;
    public static BaseAction importProjectAction;
    protected static BaseAction exportProjectAction;
    protected static BaseAction showTipsDialog;
    protected static BaseAction optionsAction;
    public static CloseProjectAction closeProjectAction;
    public static DelegateAction cutAction;
    public static DelegateAction pasteAction;
    public static DelegateAction copyAction;
    public static NewBusinessParameterAction newBusinessParameterAction;
    protected static BaseAction projectPreferencesAction;
    protected static BaseAction refreshEngineDataAction;
    protected static BaseAction cleanProjectFullSchemaAction;
    static BaseAction launchPortalAction;
    public static DesignerActions instance;
    private static DesignerAction showComponentIndexAction;
    public static BaseAction closePanelAction_d;
    public static BaseAction fullScreenAction;
    private static Image pointerIcon;
    private static boolean showNewCatalogComponents;

    public DesignerActions() {
        instance = this;
        this.setActions();
    }

    public static void setInitialized(boolean initialized) {
        DesignerActions.initialized = initialized;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static Image getPointerIcon() {
        if (pointerIcon == null) {
            pointerIcon = Image.create((Msg)UIMsg.POINTER);
        }
        return pointerIcon;
    }

    public static DesignerAction getShowComponentIndexAction() {
        if (showComponentIndexAction == null) {
            showComponentIndexAction = new ShowComponentIndexAction();
        }
        return showComponentIndexAction;
    }

    public static void controlEngineActions(boolean isRunning) {
        Project project = Context.getProject();
        launchPortalAction.setEnabled(isRunning || project != null);
    }

    public static boolean doCommand(DesignerAction action) {
        action.run();
        return true;
    }

    public void enableNewCatalogComponents(boolean hasProject) {
        showNewCatalogComponents = hasProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setActions() {
        Class<DesignerActions> clazz = DesignerActions.class;
        synchronized (DesignerActions.class) {
            if (DesignerActions.isInitialized()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            DesignerActions.setInitialized(true);
            fullScreenAction = FrameDecorators.createDefaultFrameMaximizer((Frame)((Frame)Ui.getRoot()), (Msg)UIMsg.FULL_SCREEN);
            importEnumerationAction = ImportObjectAction.getImportEnumerationAction();
            importFuegoObjectAction = ImportObjectAction.getImportFuegoObjectAction();
            importProjectAction = new ImportProjectAction();
            refreshAction = new BaseAction(DesignerMsg.SYNCHRONIZE_PROJECT){

                public void run() {
                    try {
                        RepositoryService.getInstance().getActiveRepository().refresh(Context.getProject());
                    }
                    catch (ProjectException e) {
                        MessageDialog.showError((Throwable)e);
                    }
                }
            };
            updateAction_d = new UpdateAction();
            optionsAction = new CustomFuegoAction(UIMsg.PREFERENCES){

                public void run() {
                    DesignerActions.this.optionsDialog();
                }
            };
            pageDialogAction_d.setEnabled(false);
            closePanelAction_d = new ClosePanelAction();
            closePanelAction_d.setEnabled(false);
            closeProjectAction = new CloseProjectAction();
            exportProjectAction = new ExportProjectAction();
            Project project = Context.getProject();
            newBusinessParameterAction = new NewBusinessParameterAction(project);
            newBusinessParameterAction.setEnabled(false);
            projectPreferencesAction = new ProjectPreferencesAction();
            refreshEngineDataAction = new BaseAction(DesignerMsg.REFRESH_ENGINE_DATA){

                public void run() {
                    Project project = Context.getProject();
                    if (project != null) {
                        DesignerActions.this.refreshEngineData(project);
                    }
                }
            };
            DesignerMode.setVisibility((Action)refreshEngineDataAction, 2);
            cleanProjectFullSchemaAction = new BaseAction(DesignerMsg.DELETE_PROCESS_INSTANCES){

                public void run() {
                    Project project = Context.getProject();
                }
            };
            DesignerMode.setVisibility((Action)cleanProjectFullSchemaAction, 2);
            launchPortalAction = new LaunchPortalAction();
            DesignerMode.setVisibility((Action)launchPortalAction, 2);
            launchPortalAction.setEnabled(false);
            cutAction = new DelegateAction(UIMsg.CUT);
            cutAction.setEnabled(false);
            copyAction = new DelegateAction(UIMsg.COPY);
            copyAction.setEnabled(false);
            pasteAction = new DelegateAction(UIMsg.PASTE);
            pasteAction.setEnabled(false);
            openAnythingAction_d = this.createOpenAnythingAction();
            newAnythingAction_d = this.createNewAnythingAction();
            previousMemberAction = new DelegateAction(DesignerMsg.OPEN_PREVIOUS_MEMBER);
            nextMemberAction = new DelegateAction(DesignerMsg.OPEN_NEXT_MEMBER);
            methodListAction = new DelegateAction(DesignerMsg.CIL_LIST);
            DesignerMode.setVisibility((Action)((Object)methodListAction), 2);
            showMessagesAction = new ShowMessageAction(DesignerMsg.SHOWMESSAGE);
            showTipsDialog = new ShowTipsAction(DesignerMsg.TIPS);
            ModelActionSet.get();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected BaseAction createOpenAnythingAction() {
        return new OpenAnythingAction(LibMsg.OPEN);
    }

    static Msg getApplicationNameMsg() {
        if (applicationNameMsg == null) {
            applicationNameMsg = AppInfo.getCurrent().getApplicationNameMsg();
        }
        return applicationNameMsg;
    }

    private BaseAction createNewAnythingAction() {
        return new NewAnythingAction(DesignerMsg.NEW);
    }

    private void optionsDialog() {
        StudioPreferencesDialog dialog = new StudioPreferencesDialog(Ui.getRoot());
        dialog.setVisible(true);
        this.updatePreferences();
    }

    private void refreshEngineData(Project project) {
    }

    private void updatePreferences() {
    }

    static {
        applicationNameMsg = null;
        showNewCatalogComponents = true;
    }

    private static final class ShowTipsAction
    extends BaseAction {
        private ShowTipsAction(Msg msg) {
            super(msg);
        }

        public void run() {
            TipOfTheDayFactory.showTipsDialog((UiWindow)Ui.getRoot(), (Locale)Locales.getDefaultLocale(), (boolean)CommonPreferences.getInstance().getShowTipsOnStartup());
        }
    }

    private static final class ShowMessageAction
    extends BaseAction {
        private ShowMessageAction(Msg msg) {
            super(msg);
        }

        public void actionPerformed(ActionEvent e) {
            CheckBoxMenuItem item = (CheckBoxMenuItem)e.getSource();
            Context.showMessages(item.isSelected());
        }
    }

    private static final class OpenAnythingAction
    extends BaseAction {
        private OpenAnythingAction(Msg msg) {
            super(msg);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof Button) {
                Button source = (Button)e.getSource();
                PopupMenu popup = new PopupMenu((UiContainer)source);
                popup.add(importProjectAction);
                popup.show((UiComponent)source, 0, source.getHeight());
            }
        }
    }

    private static final class NewAnythingAction
    extends BaseAction {
        private NewAnythingAction(Msg msg) {
            super(msg);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof Button) {
                Button source = (Button)e.getSource();
                PopupMenu popup = new PopupMenu((UiContainer)source);
                popup.add((BaseAction)new NewProjectAction(), true);
                popup.add(ModelActionSet.newProcessAction, true);
                popup.add(ModelActionSet.newProcedureAction, true);
                popup.add(ModelActionSet.newScreenflowAction, true);
                if (showNewCatalogComponents) {
                    Menu newAnythingCatalogMenu = new Menu((UiContainer)popup, DesignerMsg.CATALOG);
                    popup.add((MenuItem)newAnythingCatalogMenu);
                    newAnythingCatalogMenu.add((BaseAction)new NewModuleAction(), true);
                    newAnythingCatalogMenu.add((BaseAction)new NewBpmObjectAction(null), true);
                    newAnythingCatalogMenu.add((BaseAction)new NewEnumerationAction(null), true);
                }
                popup.show((UiComponent)source, 0, source.getHeight());
            }
        }
    }
}

