/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import fuego.simulation.Event;
import fuego.simulation.Simulation;
import fuego.simulation.SimulationEventListener;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.PredicateUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.command.Command;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.ActivitySimulationInterface;
import oracle.bpm.designer.DomainStateManager;
import oracle.bpm.designer.LifeCycleListener;
import oracle.bpm.designer.SingleProcessCanvas;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.designer.action.InsertLaneAction;
import oracle.bpm.designer.action.SnapToGridAction;
import oracle.bpm.designer.controller.BpmnControllerFactory;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.controller.FlowElementController;
import oracle.bpm.designer.controller.FlowNodeController;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.designer.controller.NoteController;
import oracle.bpm.designer.controller.ProcessController;
import oracle.bpm.designer.controller.RootController;
import oracle.bpm.designer.controller.SequenceFlowController;
import oracle.bpm.designer.controller.SingleProcessRootController;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.designer.selection.DesignerSelectionProvider;
import oracle.bpm.designer.selection.DomainSelectionProvider;
import oracle.bpm.designer.simulation.SimulationListener;
import oracle.bpm.draw.AntialiasingMode;
import oracle.bpm.draw.BpmnDrawableFactory;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableConnection;
import oracle.bpm.draw.DrawableSequenceFlow;
import oracle.bpm.draw.Graphics;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.command.design.MoveObjectCommand;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.ProcessLayoutFeature;
import oracle.bpm.project.model.features.ViewScaleFeature;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Grid;
import oracle.bpm.project.model.processes.Positional;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.PaintCanvas;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.event.AdjustmentEvent;
import oracle.bpm.ui.event.AdjustmentListener;
import oracle.bpm.ui.event.VisibilityAdapter;
import oracle.bpm.ui.event.VisibilityListener;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.selection.SelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class Designer
extends SingleProcessCanvas {
    public LifeCycleListener lifeCycleListener;
    @NotNull
    protected Grid grid;
    protected SimulationListener simulationListener;
    private boolean addedListener;
    private Dimension calculatedPreferredSize;
    private DomainStateManager controller;
    private List<DrawableSequenceFlow> customPaintedSequenceFlows = new ArrayList<DrawableSequenceFlow>();
    private Image designerImage = null;
    private SimulationEventListener designerSimulationEventListener;
    private boolean insertInTransition = true;
    private Point pasteLocation;
    private DrawableSequenceFlow previousClosestSequenceFlow = null;
    private Color previousColor;
    private Project project;
    private SingleProcessRootController root;
    private DesignerSelectionProvider selectionProvider;
    private boolean showAnimation = true;
    protected static int INVALID_NUMBER = Integer.MIN_VALUE;
    private static final Predicate<FlowElementController> FLOW_NODE_INSTANCE = new Predicate<FlowElementController>(){

        @Override
        public boolean check(@Nullable FlowElementController controller) {
            return controller != null && controller.getModelObject() instanceof FlowNode;
        }
    };

    public Designer(UiContainer parent, Process process) {
        super(parent);
        this.setLayout(null);
        this.project = process.getProject();
        this.root = null;
        this.initSelection();
        this.setProcessToRender(process);
        this.grid = Grid.createNull();
        DrawContext drawContext = this.getDrawContext();
        drawContext.setContainer((UiContainer)this);
        drawContext.setRenderFlowOnly(false);
        DesignerPreferences designerPreferences = DesignerPreferences.getPreferences();
        drawContext.setActivityTitleType(designerPreferences.getActivityTitleType());
        drawContext.setLocale(this.getProject().getDefaultLanguage());
        this.initSimulation();
        this.setToolTipText("");
        this.setBackground(designerPreferences.getTheme().getBackgroundColor());
        this.setOpaque(false);
        this.addListeners();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.calculatedPreferredSize == null) {
            this.calculatedPreferredSize = this.calculatePreferredSize();
        }
        return this.calculatedPreferredSize;
    }

    public Process getProcess() {
        return (Process)this.getProcessController().getModelObject();
    }

    public void addToSimulation(UiComponent comp) {
        this.add(comp);
    }

    public void addToSimulation(UiComponent comp, int index) {
        this.add(comp, index);
    }

    public void scrollRectangleToVisible(@NotNull FlowElementController controller) {
        this.scrollRectangleToVisible(controller.getDrawableObject().getBounds(this.getDrawContext()));
    }

    @Nullable
    public FlowElementController<?> findControllerInPosition(int x, int y) {
        Predicate alwaysTrue = PredicateUtils.truePredicate();
        return null;
    }

    @Nullable
    public FlowNodeController<?> findNodeControllerInPosition(@NotNull NodeContainerController<?> container, int x, int y) {
        return null;
    }

    @Nullable
    public FlowNodeController<?> findNodeControllerInPosition(int x, int y) {
        return null;
    }

    public DrawableSequenceFlow getClosestTransition() {
        return this.previousClosestSequenceFlow;
    }

    public Dimension getMinimumSize() {
        return Dimension.valueOf(200, 200);
    }

    public Point getPasteLocation() {
        return this.pasteLocation;
    }

    public BpmnDrawableFactory getDrawableFactory() {
        return BpmnDrawableFactory.getInstance();
    }

    public DesignerSelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public PaintCanvas getCanvas() {
        return this;
    }

    public void init() {
    }

    public boolean moveObject(FlowElementController dObj, Point destination) {
        ActionRunner.getInstance().run((Command)new MoveObjectCommand((Positional)dObj.getModelObject(), destination, new Grid(DesignerPreferences.getPreferences().getGridSize())));
        return true;
    }

    public void paint(Graphics cg) {
        if (DesignerPreferences.getPreferences().getSnapToGrid()) {
            SnapToGridAction.snapToGrid();
        }
        this.paintCanvas(cg);
        super.paint(cg);
    }

    public void repaint() {
        Dimension recalculated = this.calculatePreferredSize();
        if (!this.getPreferredSize().equals(recalculated)) {
            this.calculatedPreferredSize = recalculated;
            this.revalidate();
        } else {
            super.repaint();
        }
    }

    @Override
    public void paintCanvas(@NotNull Graphics graphics) {
        DesignerPreferences pref = DesignerPreferences.getPreferences();
        Grid g = pref.getShowGrid() ? new Grid(pref.getGridSize()) : Grid.createNull();
        this.setGrid(g);
        this.getDrawContext().setGrid(g);
        if (!this.addedListener) {
            this.addVerticalAdjustmentListener(new AdjustmentListener(){

                public void adjustmentValueChanged(AdjustmentEvent event) {
                    Designer.this.getDrawContext().setDeltaY(event.getValue());
                    Designer.this.repaint();
                }
            });
            this.addHorizontalAdjustmentListener(new AdjustmentListener(){

                public void adjustmentValueChanged(AdjustmentEvent event) {
                    Designer.this.getDrawContext().setDeltaX(event.getValue());
                    Designer.this.repaint();
                }
            });
            this.addedListener = true;
        }
        super.paintCanvas(graphics);
        if (AbstractStudioWorkbench.getInstance().isSimulating()) {
            this.drawSimulationImage(graphics);
        }
    }

    public void paintImmediately(Rectangle rect) {
        this.getComponentPeer().paintImmediately(rect);
    }

    public void paintImmediately(int x, int y, int w, int h) {
        this.getComponentPeer().paintImmediately(x, y, w, h);
    }

    public void setDesignerImage(Image image) {
        if (this.designerImage != image) {
            // empty if block
        }
        this.designerImage = image;
    }

    public void setPasteLocation(Point pasteLocation) {
        this.pasteLocation = pasteLocation;
    }

    public void setPopupIcons() {
    }

    public void setShowAnimation(boolean b) {
        this.showAnimation = b;
        this.repaint();
    }

    public float getViewScale() {
        return this.getDrawContext().getScale();
    }

    public boolean showAnimation() {
        return this.showAnimation;
    }

    public void stopEditingNotes() {
        for (TextAnnotation textAnnotation : this.getProcess().getTextAnnotations()) {
            FlowElementController drawableController = this.getProcessController().asController((FlowElement)textAnnotation);
            ((NoteController)drawableController).stopEditing();
        }
    }

    public String toString() {
        return "Designer " + (this.getProcess() == null ? "Content null" : this.getProcess().getId());
    }

    public void clearClosestTransition() {
        this.setPreviousClosestTransition(null);
        this.resetTransitions();
    }

    public void setInsertInTransition(boolean insertInTransition) {
        this.insertInTransition = insertInTransition;
    }

    public boolean getDrawAlternative() {
        return ModelUtils.isHorizontal((Process)this.getProcess());
    }

    public boolean isReadOnly() {
        return this.getProcess().isReadOnly();
    }

    public boolean isInsertInTransition() {
        return this.insertInTransition;
    }

    public void onDispose() {
        AbstractStudioWorkbench.getInstance().removeSimulationListener(this.simulationListener);
    }

    public void paintTransitions(Sequence<DrawableConnection> flows, Color color) {
        for (DrawableConnection flow : flows) {
            this.drawSingleTransition((DrawableSequenceFlow)flow, color);
        }
    }

    public void drawClosestTransition(DrawableSequenceFlow closestSequenceFlow) {
        if (this.isInsertInTransition() && closestSequenceFlow != this.previousClosestSequenceFlow) {
            if (closestSequenceFlow != null) {
                this.setPreviousClosestTransition(closestSequenceFlow);
                this.drawSingleTransition(closestSequenceFlow, Color.BLUE);
            } else {
                this.clearClosestTransition();
            }
        }
    }

    public void setDesignerController(@NotNull DomainStateManager controller) {
        this.controller = controller;
    }

    public DomainStateManager getDesignerController() {
        return this.controller;
    }

    @NotNull
    public ProcessController getProcessController() {
        return this.root.getSingleProcess();
    }

    @NotNull
    public Grid getGrid() {
        return this.grid;
    }

    public RootController getRootController() {
        return this.root;
    }

    public void setCurrentTool(Object o) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintSequenceFlow(@NotNull DrawableSequenceFlow sequenceFlow, @NotNull Color color) {
        DrawContext drawContext = this.getDrawContext();
        Graphics graphics = this.getGraphics();
        graphics.setAntialiasing(AntialiasingMode.ON);
        drawContext.setGraphics(graphics);
        sequenceFlow.setColor(color);
        sequenceFlow.draw(drawContext);
    }

    public BpmnControllerFactory getControllerFactory() {
        return BpmnControllerFactory.getInstance();
    }

    public DrawContext getDrawContext() {
        return DrawContext.getDefault();
    }

    protected DomainSelectionProvider initializeSelectionProvider() {
        return null;
    }

    protected DomainStateManager initializeDomainManager() {
        return null;
    }

    protected DrawContext initializeContext() {
        return null;
    }

    protected PaintCanvas initializeCanvas(@NotNull UiContainer parent) {
        return null;
    }

    @Override
    protected void clearRoot() {
        for (Controller controller : this.root.getControllers()) {
            controller.remove();
        }
    }

    @Override
    protected void addProcessToRoot(@NotNull Process process) {
    }

    @Override
    protected void initDrawContext(Graphics cg, Rectangle rect) {
        this.getDrawContext().setGraphics(cg);
        DesignerPreferences.getPreferences().updateContext(this.getDrawContext());
        this.getDrawContext().setLocale(this.getProject().getPreferences().getDefaultLanguage());
        this.getDrawContext().setScale(((ViewScaleFeature)this.getProcess().getFeature(ViewScaleFeature.class)).getValue().floatValue());
        this.getDrawContext().setRectangle(rect);
        if (this.designerImage == null) {
            Rectangle clipBounds = cg.getClipBounds();
            this.getDrawContext().setRectangle(clipBounds);
        }
        this.getDrawContext().setHorizontalDrawing(this.getDrawAlternative());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    void drawSingleTransition(DrawableSequenceFlow sequenceFlow, Color color) {
        DrawContext drawContext = this.getDrawContext();
        Graphics graphics = this.getGraphics();
        try {
            drawContext.setGraphics(graphics);
            this.customPaintedSequenceFlows.add(sequenceFlow);
            sequenceFlow.setColor(color);
            sequenceFlow.draw(drawContext);
        }
        finally {
            graphics.dispose();
            drawContext.setGraphics(null);
        }
    }

    private void initSelection() {
        this.selectionProvider = new DesignerSelectionProvider();
        this.selectionProvider.addSelectionListener(new SelectionListener(){

            public void selectionChanged(Selection selection) {
                System.out.println("Designer.selectionChanged :: " + selection.size());
                if (!selection.isEmpty()) {
                    for (FlowElementController controller : selection.asList(FlowElementController.class)) {
                        System.out.println("\t\tDesigner.selectionChanged PART : " + controller.getModelObject().getDefaultLabel() + "(" + controller.getId() + ") > " + controller);
                    }
                } else {
                    System.out.println("\t\tDesigner.selectionChanged EMPTY");
                }
                Designer.this.repaint();
            }
        });
    }

    private Dimension calculatePreferredSize() {
        return this.getDrawableProcess().getBounds(this.getDrawContext()).getSize();
    }

    private void setGrid(@NotNull Grid g) {
        this.grid = g;
    }

    private void addListeners() {
        final ViewScaleFeature scaleFeature = (ViewScaleFeature)this.getProcess().getFeature(ViewScaleFeature.class);
        final ProcessLayoutFeature horizontalLayoutFeature = (ProcessLayoutFeature)this.getProcess().getFeature(ProcessLayoutFeature.class);
        final ModificationListener<Feature> listenerForRepainting = new ModificationListener<Feature>(){

            @Override
            public void objectModified(ModificationEvent<Feature> event) {
                Designer.this.getDrawContext().setScale(((ViewScaleFeature)Designer.this.getProcess().getFeature(ViewScaleFeature.class)).getValue().floatValue());
                Designer.this.repaint();
            }
        };
        this.addVisibilityListener((VisibilityListener)new VisibilityAdapter(){

            public void onDispose() {
                scaleFeature.removeModificationListener(listenerForRepainting);
                horizontalLayoutFeature.removeModificationListener(listenerForRepainting);
            }
        });
        scaleFeature.addModificationListener((ModificationListener)listenerForRepainting);
        horizontalLayoutFeature.addModificationListener((ModificationListener)listenerForRepainting);
    }

    private void drawSimulationImage(Graphics graphics) {
        this.getProcessController().drawSimulation(graphics);
        super.paint(graphics);
    }

    private void initSimulation() {
        this.designerSimulationEventListener = new DesignerSimulationEventListener();
        StudioWorkbench workbench = AbstractStudioWorkbench.getInstance();
        if (workbench == null) {
            return;
        }
        if (workbench.isSimulating()) {
            workbench.getSimulation().addEventListener(this.designerSimulationEventListener);
        }
        this.simulationListener = new SimulationListener(){

            @Override
            public void simulationStarted(Simulation simulation) {
                if (simulation != null) {
                    simulation.addEventListener(Designer.this.designerSimulationEventListener);
                }
            }

            @Override
            public void simulationStopped(Simulation simulation) {
                if (simulation != null) {
                    simulation.removeEventListener(Designer.this.designerSimulationEventListener);
                }
            }
        };
        workbench.addSimulationListener(this.simulationListener);
    }

    private void insertRole(Role role, Point location) {
        InsertLaneAction.createInsertRoleAction(this.getProcess().createLane(role.getId()), location).run();
    }

    private Project getProject() {
        return this.project;
    }

    private void setPreviousClosestTransition(DrawableSequenceFlow closestSequenceFlow) {
        if (this.previousClosestSequenceFlow != null) {
            this.drawSingleTransition(this.previousClosestSequenceFlow, this.previousColor);
        }
        this.previousClosestSequenceFlow = closestSequenceFlow;
        if (closestSequenceFlow != null) {
            this.previousColor = closestSequenceFlow.getColor();
        }
    }

    private void resetTransitions() {
        if (!this.customPaintedSequenceFlows.isEmpty()) {
            for (DrawableSequenceFlow drawableSequenceFlow : new ArrayList<DrawableSequenceFlow>(this.customPaintedSequenceFlows)) {
                drawableSequenceFlow.setColor(Color.BLACK);
            }
            this.customPaintedSequenceFlows.clear();
            this.repaint();
        }
    }

    private class DesignerSimulationEventListener
    implements SimulationEventListener {
        private static final int SIMULATION_THREAD_SLEEP = 50;

        private DesignerSimulationEventListener() {
        }

        public void eventDue(List<Event> eventList) {
            StudioWorkbench workbench = AbstractStudioWorkbench.getInstance();
            final Simulation simulation = workbench.getSimulation();
            for (Event event : eventList) {
                switch (event.getType()) {
                    case 2: 
                    case 6: {
                        boolean transitionExists;
                        if (event.getFrom() != null && event.getFrom().getProcess() != Designer.this.getDrawableProcess().getModelObject() || event.getTo() != null && event.getTo().getProcess() != Designer.this.getDrawableProcess().getModelObject()) break;
                        ActivitySimulationInterface from = (ActivitySimulationInterface)((Object)Designer.this.getProcessController().asController((FlowElement)event.getFrom()));
                        ActivitySimulationInterface to = (ActivitySimulationInterface)((Object)Designer.this.getProcessController().asController((FlowElement)event.getTo()));
                        if (event.isFirstStep()) {
                            from.updateSimulationValues();
                        }
                        if (transitionExists = Designer.this.getProcessController().contains((FlowElement)event.getTransition())) {
                            SequenceFlowController sequenceFlowController = (SequenceFlowController)Designer.this.getProcessController().asController((FlowElement)event.getTransition());
                            sequenceFlowController.setSimulationNextPercentage(event.getStep());
                        }
                        if (!event.isLastStep() && (simulation == null || simulation.isPerformingAnimation())) break;
                        to.updateSimulationValues();
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 5: {
                        return;
                    }
                }
            }
            if (simulation != null && simulation.isPerformingAnimation()) {
                UiUtilities.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!Designer.this.isDisposed() && simulation.isPerformingAnimation()) {
                            Designer.this.repaint();
                        }
                    }
                });
                try {
                    double timeScalePct = simulation.getTimeScalePct();
                    int sleepTime = 50 - (int)(48.0 * timeScalePct / 100.0);
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

