/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.designer.BaseTransitionPropertiesDialog;
import oracle.bpm.designer.SequenceFlowPropertiesDialog;
import oracle.bpm.designer.argumentmapping.expressionfield.ExpressionPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.ConditionalFlow;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.TransitionType;
import oracle.bpm.project.model.processes.transitions.ConditionalTransitionFeature;
import oracle.bpm.project.transitions.FeaturesByTransition;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;

class ConditionalTransitionPanel
extends BaseTransitionPropertiesDialog.TransitionPanel {
    private ExpressionPanel expressionPanel;
    private SequenceFlowPropertiesDialog propertiesDialog;
    private ConditionalFlow sequenceFlow;

    public ConditionalTransitionPanel(UiContainer parent, SequenceFlowPropertiesDialog propertiesDialog) {
        super(parent, FeaturesByTransition.get((TransitionType)TransitionType.CONDITIONAL));
        this.propertiesDialog = propertiesDialog;
        this.sequenceFlow = propertiesDialog.getSequenceFlow().toConditionalFlow();
        this.setLayout((Layout)new MigLayout("ins 0, gap 5, fillx"));
        this.setSequenceFlow(this.sequenceFlow);
        Label expressionLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.EXPRESSION);
        CatalogType resultType = CatalogType.Default.getBool();
        NodeContainer container = this.getSequenceFlow().getParentObject();
        DataDeclarationContainer context = container instanceof DataDeclarationContainer ? (DataDeclarationContainer)container : this.getSequenceFlow().getProcess();
        this.expressionPanel = ExpressionPanel.createWithRadioSelector((UiContainer)this, context, resultType);
        this.add((UiComponent)expressionLabel, "wrap");
        this.add(this.expressionPanel.getUiComponent(), "growx");
    }

    public SequenceFlowPropertiesDialog getPropertiesDialog() {
        return this.propertiesDialog;
    }

    public SequenceFlow getSequenceFlow() {
        return this.sequenceFlow;
    }

    @Override
    public void check() throws ProjectException {
        if (this.expressionPanel != null && this.expressionPanel.getExpression() != null && !this.expressionPanel.isValid()) {
            throw new ProjectException((ProjectObject)this.sequenceFlow, DesignerMsg.INVALID_EXPRESSION);
        }
    }

    @Override
    public void focus() {
        this.expressionPanel.requestFocus();
    }

    @Override
    public void objectToPanel() {
        this.getFeatures().copyFrom(this.getSequenceFlow().getFeatures());
        ConditionalTransitionFeature methodFeature = this.getFeature(ConditionalTransitionFeature.class);
        if (methodFeature != null && methodFeature.getValue() != null) {
            Expression expression = methodFeature.getValue();
            this.expressionPanel.setExpression(expression);
        }
    }

    @Override
    public boolean panelToObject() {
        ConditionalTransitionFeature methodFeature = this.getFeature(ConditionalTransitionFeature.class);
        methodFeature.setValue(this.expressionPanel.getExpression());
        this.getSequenceFlow().getFeatures().copyFrom(this.getFeatures());
        return true;
    }

    @Override
    public void reinit(SequenceFlow transition) {
        this.setSequenceFlow(transition.asConditionalFlow());
        this.expressionPanel.requestFocus();
    }

    private void setSequenceFlow(ConditionalFlow sequenceFlow) {
        this.sequenceFlow = sequenceFlow;
    }
}

