/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.CatalogObjectEditor;
import oracle.bpm.designer.types.TypeChooserPanel;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.ToggleButton;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.ui.text.TextField;

public abstract class ComponentStructureAbstractPanel
extends CatalogObjectEditor {
    private List<ChangeListener> changeListeners;
    private boolean readOnly;
    private boolean receiveEvents = true;
    private final TypeChooserPanel.EnsuredItemListener<CatalogType> typeChooserPanelListener = new TypeChooserPanel.EnsuredItemListener<CatalogType>(){

        @Override
        public void itemStateChanged(TypeChooserPanel.EnsuredItemEvent<CatalogType> event) {
            ComponentStructureAbstractPanel.this.changed();
        }
    };

    public ComponentStructureAbstractPanel(UiContainer parent, CatalogObject catalogObject) {
        super(parent, catalogObject);
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ChangeListener>();
        }
        this.changeListeners.add(changeListener);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public final void addListener(final TextField tx) {
        final DocumentListener doc = new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ComponentStructureAbstractPanel.this.changed();
            }

            public void removeUpdate(DocumentEvent e) {
                ComponentStructureAbstractPanel.this.changed();
            }

            public void changedUpdate(DocumentEvent e) {
            }
        };
        tx.addDocumentListener(doc);
        if (tx.isSwing()) {
            tx.asSwing().addPropertyChangeListener("document", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    tx.addDocumentListener(doc);
                }
            });
        }
    }

    public final void addListener(ComboBox combo) {
        combo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ComponentStructureAbstractPanel.this.changed();
            }
        });
    }

    public final void addListener(ToggleButton check) {
        check.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ComponentStructureAbstractPanel.this.changed();
            }
        });
    }

    public final void addListener(NumericField check) {
        check.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ComponentStructureAbstractPanel.this.changed();
            }
        });
    }

    public final void addListener(TypeChooserPanel typeChooserPanel) {
        if (!typeChooserPanel.containsTypedItemListener(this.typeChooserPanelListener)) {
            typeChooserPanel.addTypedItemListener(this.typeChooserPanelListener);
        }
    }

    public final void changed() {
        this.notifyListeners(new ChangeEvent((Object)this));
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isReceiveEvents() {
        return this.receiveEvents;
    }

    protected final void disableEvents() {
        this.receiveEvents = false;
    }

    protected final void enableEvents() {
        this.receiveEvents = true;
    }

    private void notifyListeners(ChangeEvent e) {
        if (this.changeListeners != null && this.receiveEvents) {
            for (ChangeListener listener : this.changeListeners) {
                listener.stateChanged(e);
            }
        }
    }
}

