/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.designer.CatalogObjectEditor;
import oracle.bpm.designer.context.StudioContext;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.observers.ObjectPropertyListener;
import oracle.bpm.observers.ObjectRelationListener;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextField;

@Deprecated
public class ComponentHeaderPanel
extends Panel {
    private TextField configField;
    private TextField descrField;
    private Label descrLabel;
    private DescriptionDocumentListener documentListener = new DescriptionDocumentListener();
    private boolean doShowHiddencheck;
    private ObjectTypeDescription objectType;
    private HeaderPanelListener panelListener = new HeaderPanelListener();
    private CatalogObjectEditor parentPanel;
    private ComboBox<String> presentationCombo;
    private Label presentationLabel;
    private List<String> presentationList;
    private CheckBox runsOnClientCheck;
    private CheckBox showHiddenCheck;

    public ComponentHeaderPanel(UiContainer parent, ObjectTypeDescription component, CatalogObjectEditor parentPanel) {
        this(parent, component, parentPanel, true);
    }

    public ComponentHeaderPanel(UiContainer parent, ObjectTypeDescription component, CatalogObjectEditor parentPanel, boolean showHiddencheck) {
        super(parent, UIMsg.TO_MSG((String)""));
        this.objectType = component;
        this.parentPanel = parentPanel;
        this.doShowHiddencheck = showHiddencheck;
        this.presentationList = new ArrayList<String>();
        this.init();
    }

    public void setContext(StudioContext context) {
    }

    public UiComponent getDescriptionField() {
        return this.descrField;
    }

    public boolean doUpdate() {
        this.getObjectType().setDescription(this.descrField.getText());
        if (this.getObjectType().isBpmObject() && this.getObjectType().hasModifiers(0x40000000L)) {
            ((XObjectTypeDescription)this.getObjectType()).setDefaultPresentationName((String)this.presentationCombo.getSelectedItem());
        }
        if (this.runsOnClientCheck != null && this.getObjectType().isRemote() != this.runsOnClientCheck.isSelected()) {
            this.getObjectType().setRemote(this.runsOnClientCheck.isSelected());
        }
        return true;
    }

    public void refresh() {
        this.objectType = (ObjectTypeDescription)this.getObjectType().getRef().get();
        this.initDefaults();
    }

    public boolean showHidden() {
        return this.showHiddenCheck != null && this.showHiddenCheck.isSelected();
    }

    public ObjectTypeDescription getObjectType() {
        return this.objectType;
    }

    public void dispose() {
        if (this.isRecyclable()) {
            super.dispose();
        }
        this.removeListeners();
    }

    private boolean isEditable() {
        return !this.getObjectType().isDefault() && !this.parentPanel.isReadOnly();
    }

    private void addListeners() {
        if (!this.parentPanel.isReadOnly()) {
            this.descrField.addDocumentListener((DocumentListener)this.documentListener);
            this.objectType.addPropertyObserver("description", this.panelListener);
            this.objectType.addPropertyObserver("defaultPresentation", this.panelListener);
            this.objectType.addRelationObserver("presentation", this.panelListener);
            this.objectType.addRelationObserver("superType", this.panelListener);
        }
    }

    private void removeListeners() {
        if (!this.parentPanel.isReadOnly()) {
            this.descrField.removeDocumentListener((DocumentListener)this.documentListener);
            this.objectType.removePropertyObserver("description", this.panelListener);
            this.objectType.removePropertyObserver("defaultPresentation", this.panelListener);
            this.objectType.removeRelationObserver("presentation", this.panelListener);
            this.objectType.removeRelationObserver("superType", this.panelListener);
        }
    }

    private void fireObjectChanged() {
    }

    private void build() {
        String configName;
        boolean isConfig;
        String colSpecs = "5dlu, default, 5dlu, default,5dlu, default, 5dlu, default, 5dlu:grow";
        String rowSpecs = "5dlu, default, 5dlu, default, default, 5dlu";
        FormLayout layout = new FormLayout(colSpecs, rowSpecs);
        PanelBuilder builder = layout.createBuilder((Panel)this);
        this.descrLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.DESCRIPTION);
        this.descrField = new TextField((UiContainer)this, 25);
        boolean isEditable = this.isEditable();
        this.descrField.setEditable(isEditable);
        this.descrField.setText(this.getObjectType().getDescription());
        CellConstraints cellConstraints = layout.createCellConstraints();
        builder.add((UiComponent)this.descrLabel, cellConstraints.xy(2, 2));
        builder.add((UiComponent)this.descrField, cellConstraints.xy(4, 2));
        this.runsOnClientCheck = this.createRunsOnClientCheck();
        builder.add((UiComponent)this.runsOnClientCheck, cellConstraints.xy(6, 2));
        if (this.getObjectType().isBpmObject()) {
            this.presentationLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.DEFAULT_PRESENTATION);
            this.presentationCombo = UiFactory.createMutableComboBox((UiContainer)this, this.presentationList);
            this.presentationCombo.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXX");
            this.presentationCombo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ComponentHeaderPanel.this.fireObjectChanged();
                    ((XObjectTypeDescription)ComponentHeaderPanel.this.getObjectType()).setDefaultPresentationName((String)ComponentHeaderPanel.this.presentationCombo.getSelectedItem());
                }
            });
            this.presentationCombo.setEnabled(this.isEditable());
            builder.add((UiComponent)this.presentationLabel, cellConstraints.xy(2, 4));
            builder.add(this.presentationCombo, cellConstraints.xy(4, 4));
        }
        boolean bl = isConfig = (configName = this.getObjectType().getProperty("configName")) != null && !configName.equals("");
        if (isConfig) {
            Label configLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.EXTERNAL_RESOURCE);
            this.configField = new TextField((UiContainer)this, 25);
            this.configField.setEditable(false);
            this.configField.setText(configName);
            builder.add((UiComponent)configLabel, cellConstraints.xy(2, 5));
            builder.add((UiComponent)this.configField, cellConstraints.xy(4, 5));
        }
        if (this.doShowHiddencheck) {
            this.showHiddenCheck = CheckBox.create((UiContainer)this, (Msg)DesignerMsg.SHOW_HIDDEN_METHODS);
            this.showHiddenCheck.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                }
            });
            builder.add((UiComponent)this.showHiddenCheck, cellConstraints.xy(6, 5));
        }
    }

    private CheckBox createRunsOnClientCheck() {
        CheckBox result = CheckBox.create((UiContainer)this, (Msg)DesignerMsg.RUNS_ON_CLIENT);
        result.setVisible(true);
        result.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ComponentHeaderPanel.this.fireObjectChanged();
            }
        });
        result.setEnabled(this.isEditable() && this.getObjectType().isRemoteEnabled() && this.getObjectType().isLocalEnabled());
        result.setSelected(this.getObjectType().isRemote());
        return result;
    }

    private void init() {
        this.build();
        this.initDefaults();
        this.addListeners();
    }

    private void initCombo() {
        boolean changed = false;
        if (this.getObjectType().isBpmObject()) {
            XObjectTypeDescription xo = (XObjectTypeDescription)this.getObjectType();
            boolean isPresentable = xo.isPresentable();
            boolean bl = changed = isPresentable != this.presentationCombo.isVisible();
            if (isPresentable) {
                String presentationName = xo.getDefaultPresentationName();
                String[] presentationNames = xo.getPresentationsName();
                int oldSize = this.presentationList.size();
                this.presentationList.clear();
                int length = presentationNames.length;
                for (int i = 0; i < length; ++i) {
                    this.presentationCombo.addItem((Object)presentationNames[i]);
                }
                this.presentationCombo.setSelectedItem((Object)presentationName);
                changed = changed || this.presentationList.size() != oldSize;
            }
            this.presentationCombo.setVisible(isPresentable);
            this.presentationLabel.setVisible(isPresentable);
        }
    }

    private void initDefaults() {
        if (this.getObjectType().isBpmObject()) {
            this.initCombo();
        }
    }

    private class HeaderPanelListener
    implements ObjectPropertyListener,
    ObjectRelationListener {
        private boolean isChanging = false;

        private HeaderPanelListener() {
        }

        @Override
        public void propertyChanged(Object object, String propertyName) {
            if ("defaultPresentation".equals(propertyName)) {
                this.updateDefaultPresentation(object);
            }
            if ("description".equals(propertyName)) {
                this.updateDescription(object);
            }
        }

        @Override
        public void relationAdded(Object object, String relationName) {
            if ("presentation".equals(relationName)) {
                ComponentHeaderPanel.this.initCombo();
            }
            if ("superType".equals(relationName)) {
                // empty if block
            }
        }

        @Override
        public void relationRemoved(Object object, String relationName) {
            if ("presentation".equals(relationName)) {
                ComponentHeaderPanel.this.initCombo();
            }
            if ("superType".equals(relationName)) {
                // empty if block
            }
        }

        private void updateDescription(Object object) {
            if (!(this.isChanging || ComponentHeaderPanel.this.descrField.isDisposed() || ComponentHeaderPanel.this.descrField.getText().equals(ComponentHeaderPanel.this.objectType.getDescription()))) {
                ComponentHeaderPanel.this.descrField.setText(ComponentHeaderPanel.this.objectType.getDescription());
                ComponentHeaderPanel.this.fireObjectChanged();
            }
        }

        private void updateDefaultPresentation(Object object) {
            XObjectTypeDescription typeDescription = (XObjectTypeDescription)ComponentHeaderPanel.this.objectType;
            String defaultPresentationName = typeDescription.getDefaultPresentationName();
            if (defaultPresentationName != null && !ComponentHeaderPanel.this.presentationCombo.isDisposed() && !ComponentHeaderPanel.this.presentationCombo.getText().equals(defaultPresentationName)) {
                ComponentHeaderPanel.this.presentationCombo.setSelectedItem((Object)defaultPresentationName);
                ComponentHeaderPanel.this.fireObjectChanged();
            }
        }
    }

    public class DescriptionDocumentListener
    implements DocumentListener {
        private boolean isChanging = false;

        public void changedUpdate(DocumentEvent e) {
            if (!this.isChanging) {
                this.isChanging = true;
                ComponentHeaderPanel.this.fireObjectChanged();
                this.isChanging = false;
            }
        }

        public void insertUpdate(DocumentEvent e) {
            if (!this.isChanging) {
                this.isChanging = true;
                ComponentHeaderPanel.this.fireObjectChanged();
                this.isChanging = false;
            }
        }

        public void removeUpdate(DocumentEvent e) {
            if (!this.isChanging) {
                this.isChanging = true;
                ComponentHeaderPanel.this.fireObjectChanged();
                this.isChanging = false;
            }
        }
    }
}

