/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Positional;
import oracle.bpm.project.ui.ModelObjectSelection;

public class Clipboard {
    private final List<ClipboardListener> listeners = new ArrayList<ClipboardListener>();
    private ModelObjectSelection objects = ModelObjectSelection.create(new ArrayList());
    private static Clipboard instance;

    private Clipboard() {
    }

    public static Clipboard getInstance() {
        if (instance == null) {
            instance = new Clipboard();
        }
        return instance;
    }

    public boolean isEmpty() {
        return this.objects == null || this.objects.isEmpty();
    }

    public ModelObjectSelection getObjects() {
        return this.objects;
    }

    public void setObjects(ModelObjectSelection collection) {
        this.objects = collection;
        this.notifyChange();
    }

    public boolean contains(Positional object) {
        return this.objects.containsObject((FlowNode)object);
    }

    public int size() {
        return this.objects != null ? this.objects.size() : 0;
    }

    public String toString() {
        return "Clipboard: " + this.objects;
    }

    public boolean canPaste() {
        return !this.isEmpty() && this.containsActivities();
    }

    public void clear() {
        this.objects.clear();
        this.notifyChange();
    }

    public void addClipboardListener(ClipboardListener listener) {
        this.listeners.add(listener);
    }

    public void removeClipboardListener(ClipboardListener listener) {
        this.listeners.remove(listener);
    }

    private boolean containsActivities() {
        if (this.objects != null) {
            for (FlowElement modelObject : this.objects) {
                if (!(modelObject instanceof FlowNode)) continue;
                return true;
            }
        }
        return false;
    }

    private void notifyChange() {
        for (ClipboardListener listener : this.listeners) {
            listener.clipboardChanged();
        }
    }

    public static interface ClipboardListener {
        public void clipboardChanged();
    }
}

