/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.designer.AbstractEditor;
import oracle.bpm.designer.IconFactory;
import oracle.bpm.designer.catalog.components.ComponentStructurePanel;
import oracle.bpm.designer.catalog.enumeration.EnumPanel;
import oracle.bpm.designer.catalog.panel.BpmObjectPanel;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.UiContainer;

public abstract class CatalogObjectEditor
extends AbstractEditor<CatalogObject> {
    protected CatalogObjectEditor(UiContainer parent, CatalogObject catalogObject) {
        super(parent, catalogObject, CatalogObject.class);
    }

    public static CatalogObjectEditor create(UiContainer parent, CatalogObject catalogObject) {
        boolean isBPMO;
        ObjectTypeDescription object = catalogObject.getObjectType();
        String type = object.getComponentType();
        boolean isEnum = ComponentType.ENUMERATION.getText().equals(type);
        boolean bl = isBPMO = ComponentType.XOBJECT.getText().equals(type) && !catalogObject.isService();
        CatalogObjectEditor result = isEnum ? new EnumPanel(parent, catalogObject) : (isBPMO ? new BpmObjectPanel(parent, catalogObject.asBpmObject()) : new ComponentStructurePanel(parent, catalogObject));
        return result;
    }

    @Override
    public Image getIcon() {
        return IconFactory.getIconFor(((CatalogObject)this.getProjectObject()).getDelegate());
    }
}

