/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import oracle.bpm.designer.Checkeable;
import oracle.bpm.designer.DesignerMode;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.SequenceFlowImpl;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.features.Features;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.TransitionType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.BorderPanel;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.Constraint;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextField;

public abstract class BaseTransitionPropertiesDialog
extends OkCancelDialog {
    protected TextField nameField;
    protected TransitionPanel namePanel;
    private TextArea description;
    private SequenceFlow sequenceFlow;
    private ComboBox typesCombo;

    public BaseTransitionPropertiesDialog(UiWindow app, boolean modal) {
        super(app, modal);
    }

    public SequenceFlow getSequenceFlow() {
        return this.sequenceFlow;
    }

    public boolean isNameFieldEmpty() {
        return "".equals(this.getNameFieldText());
    }

    public String getNameFieldText() {
        return this.nameField.getText().trim();
    }

    protected SequenceFlowImpl getSequenceFlowImpl() {
        return (SequenceFlowImpl)this.sequenceFlow;
    }

    protected void enableTypesCombo() {
        this.typesCombo.setEnabled(true);
    }

    protected void init(SequenceFlow sequenceFlow) {
        if (sequenceFlow == null) {
            throw new IllegalArgumentException("Transition cannot be null");
        }
        this.sequenceFlow = sequenceFlow;
        this.typesCombo.setSelectedItem((Object)this.getSequenceFlowImpl().getTransitionType());
        if (this.typesCombo.getSelectedItem() == null) {
            this.typesCombo.setSelectedIndex(0);
        }
        this.updateView();
        FlowNode source = this.getSequenceFlow().getSource();
        FlowNode target = this.getSequenceFlow().getTarget();
        String dialogTitle = DesignerMsg.TRANSITION_FROM_TO(source.getDefaultLabel(), target.getDefaultLabel()).getString();
        this.setTitle(dialogTitle);
        if (this.getSequenceFlow().getProcess().isReadOnly()) {
            this.okButton.setEnabled(false);
        }
    }

    protected TransitionType getSelectedType() {
        TransitionType transitionType = (TransitionType)this.typesCombo.getSelectedItem();
        if (transitionType == null) {
            transitionType = this.getSequenceFlowImpl().getTransitionType();
        }
        return transitionType;
    }

    protected void setSequenceFlow(SequenceFlow sequenceFlow) {
        if (sequenceFlow == null) {
            throw new IllegalArgumentException("Transition argument cannot be null");
        }
        this.sequenceFlow = sequenceFlow;
    }

    protected void addNameFieldListener(final ChangeListener changeListener) {
        this.nameField.addDocumentListener(new DocumentListener(){

            private void update() {
                changeListener.stateChanged(new ChangeEvent((Object)BaseTransitionPropertiesDialog.this.nameField));
                BaseTransitionPropertiesDialog.this.nameField.requestFocus();
            }

            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            public void removeUpdate(DocumentEvent e) {
                this.update();
            }
        });
    }

    protected TransitionPanel buildCommonPanel(UiContainer parent) {
        SequenceFlow sequenceFlow = this.getSequenceFlow();
        assert (sequenceFlow != null) : "Null transition found";
        CommonPanel commonPanel = new CommonPanel(parent, sequenceFlow);
        commonPanel.setLayout((Layout)new BorderLayout());
        Panel typePanel = new Panel((UiContainer)commonPanel, CoreMsg.TYPE);
        typePanel.setLayout((Layout)new BorderLayout());
        TransitionComboModel model = new TransitionComboModel(sequenceFlow.getSource());
        this.typesCombo = UiFactory.createComboBox((UiContainer)typePanel);
        this.typesCombo.setModel((ComboBoxModel)model);
        typePanel.add((UiComponent)this.typesCombo, (Object)"Center");
        typePanel.add(Box.createRigidArea((UiContainer)typePanel, (Dimension)Dimension.valueOf(5, 5)), (Object)"South");
        this.typesCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                BaseTransitionPropertiesDialog.this.updateView();
            }
        });
        commonPanel.add((UiComponent)typePanel, "Center");
        return commonPanel;
    }

    protected TransitionPanel buildDescPanel(UiContainer parent) {
        TransitionPanel commonPanel = new TransitionPanel(parent, this.getSequenceFlow().getFeatures()){

            @Override
            public void check() {
            }

            @Override
            public void objectToPanel() {
                BaseTransitionPropertiesDialog.this.description.setText(BaseTransitionPropertiesDialog.this.getSequenceFlow().getDefaultDescription());
                BaseTransitionPropertiesDialog.this.namePanel.objectToPanel();
            }

            @Override
            public boolean panelToObject() {
                BaseTransitionPropertiesDialog.this.getSequenceFlow().setDefaultDescription(BaseTransitionPropertiesDialog.this.description.getText());
                return BaseTransitionPropertiesDialog.this.namePanel.panelToObject();
            }

            @Override
            public void focus() {
                BaseTransitionPropertiesDialog.this.nameField.requestFocus();
            }
        };
        Panel descPanel = new Panel((UiContainer)commonPanel);
        this.namePanel = this.buildNamePanel((UiContainer)descPanel);
        this.description = new TextArea((UiContainer)descPanel);
        this.description.setRows(8);
        this.description.setColumns(30);
        this.description.setWrapStyleWord(true);
        this.description.setLineWrap(true);
        commonPanel.setLayout((Layout)new BorderLayout());
        commonPanel.add((UiComponent)descPanel, "Center");
        RelativeLayout layout = new RelativeLayout();
        descPanel.setLayout((Layout)layout);
        descPanel.add((UiComponent)this.namePanel, (Object)"namePanel");
        descPanel.add((UiComponent)Label.create((UiContainer)descPanel, (Msg)DesignerMsg.DESCRIPTION), (Object)"label");
        descPanel.add((UiComponent)this.description, (Object)"description");
        layout.addConstraint("namePanel", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP, 10));
        layout.addConstraint("namePanel", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 2));
        layout.addConstraint("namePanel", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT, -2));
        layout.addConstraint("label", AttributeType.TOP, (Constraint)new AttributeConstraint("namePanel", AttributeType.BOTTOM, 20));
        layout.addConstraint("label", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 2));
        layout.addConstraint("description", AttributeType.TOP, (Constraint)new AttributeConstraint("label", AttributeType.BOTTOM, 2));
        layout.addConstraint("description", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 2));
        layout.addConstraint("description", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("_container", AttributeType.BOTTOM, -2));
        layout.addConstraint("description", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT, -2));
        return commonPanel;
    }

    protected TransitionPanel buildNamePanel(UiContainer parent) {
        RelativeLayout layout = new RelativeLayout();
        TransitionPanel panel = new TransitionPanel(parent, this.getSequenceFlow().getFeatures()){

            @Override
            public void check() {
            }

            @Override
            public void objectToPanel() {
                BaseTransitionPropertiesDialog.this.nameField.setText(BaseTransitionPropertiesDialog.this.getSequenceFlowImpl().getUserName());
            }

            @Override
            public boolean panelToObject() {
                BaseTransitionPropertiesDialog.this.getSequenceFlowImpl().setUserName(BaseTransitionPropertiesDialog.this.getNameFieldText());
                return true;
            }

            @Override
            public void focus() {
                BaseTransitionPropertiesDialog.this.nameField.requestFocus();
            }

            @Override
            public void reinit(SequenceFlow sequenceFlow) {
                BaseTransitionPropertiesDialog.this.nameField.requestFocus();
            }
        };
        panel.setLayout((Layout)layout);
        this.nameField = new TextField((UiContainer)panel, 30);
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)ProjectDrawMsg.NAME), "label");
        panel.add((UiComponent)this.nameField, "name");
        layout.addConstraint("label", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP, 2));
        layout.addConstraint("label", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("name", AttributeType.TOP, (Constraint)new AttributeConstraint("label", AttributeType.BOTTOM, 2));
        layout.addConstraint("name", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT));
        layout.addConstraint("name", AttributeType.LEFT, (Constraint)new AttributeConstraint("label", AttributeType.LEFT));
        return panel;
    }

    protected void updateView() {
    }

    private class CommonPanel
    extends TransitionPanel {
        private final SequenceFlowImpl sequenceFlow;

        public CommonPanel(UiContainer parent, SequenceFlow sequenceFlow) {
            super(parent, BaseTransitionPropertiesDialog.this.getSequenceFlow().getFeatures());
            this.sequenceFlow = (SequenceFlowImpl)sequenceFlow;
        }

        @Override
        public void check() {
        }

        @Override
        public void objectToPanel() {
            BaseTransitionPropertiesDialog.this.typesCombo.setSelectedItem((Object)this.sequenceFlow.getTransitionType());
        }

        @Override
        public boolean panelToObject() {
            this.sequenceFlow.setTransitionType((TransitionType)BaseTransitionPropertiesDialog.this.typesCombo.getSelectedItem());
            return true;
        }
    }

    public class TransitionComboModel
    extends AbstractListModel
    implements ComboBoxModel {
        private int selectedIndex;
        private List transitions = new ArrayList();

        public TransitionComboModel(FlowNode sourceNode) {
            this.loadAvailableTransitions(sourceNode);
            this.selectedIndex = -1;
        }

        @Override
        public Object getElementAt(int index) {
            return this.transitions.get(index);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            int index = this.transitions.indexOf(anItem);
            this.selectedIndex = index >= 0 ? index : -1;
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedIndex >= 0 ? this.transitions.get(this.selectedIndex) : null;
        }

        @Override
        public int getSize() {
            return this.transitions.size();
        }

        private void loadAvailableTransitions(FlowNode source) {
            List list = BaseTransitionPropertiesDialog.this.getSequenceFlowImpl().getAllowedTransitionTypes();
            ArrayList<TransitionType> validTransitions = new ArrayList<TransitionType>();
            for (TransitionType transitionType : list) {
                if (!DesignerMode.isValid(transitionType)) continue;
                validTransitions.add(transitionType);
            }
            this.transitions = validTransitions;
        }
    }

    public static abstract class TransitionPanel
    extends BorderPanel
    implements TransitionCheckeable {
        protected Features features;

        public TransitionPanel(UiContainer parent, Features featuresForType) {
            super(parent);
            this.features = featuresForType;
        }

        public <T extends Feature> boolean hasFeature(Class<T> clazz) {
            return this.getFeature(clazz) != null;
        }

        public <T extends Feature> T getFeature(Class<T> clazz) {
            return (T)this.features.getFeature(clazz);
        }

        public Features getFeatures() {
            return this.features;
        }

        public boolean showsInBusinessAnalyst() {
            return false;
        }

        public boolean showsInBusinessArchitect() {
            return false;
        }

        @Override
        public void focus() {
        }

        @Override
        public void reinit(SequenceFlow sequenceFlow) {
        }

        public void updateLayout() {
        }
    }

    public static interface TransitionCheckeable
    extends Checkeable {
        public void focus();

        public void reinit(SequenceFlow var1);
    }
}

