/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.design.LayoutModelCommand;
import oracle.bpm.project.model.processes.Grid;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.PopUpWindow;
import oracle.bpm.ui.ToggleButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.EmptyBorder;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class AutoLayoutPanel
extends Button {
    private final ProcessDomain domain;
    private static final Border EMPTY = new EmptyBorder(1, 1, 1, 1);

    private AutoLayoutPanel(@NotNull UiContainer parent, @NotNull ProcessDomain domain) {
        super(parent, LayoutModelCommand.getMsg(), 11);
        this.domain = domain;
        this.build();
    }

    public static AutoLayoutPanel create(@NotNull UiContainer parent, @NotNull ProcessDomain domain) {
        return new AutoLayoutPanel(parent, domain);
    }

    private void build() {
        this.setBorder(EMPTY);
        final PopUpWindow window = new PopUpWindow(this.getOwnerWindow(), false, false);
        final Panel content = new Panel((UiContainer)window, DesignerMsg.AUTOMATIC_LAYOUT);
        content.setLayout((Layout)new MigLayout("fill, gap 5, ins 2"));
        window.add((UiComponent)content);
        final ToggleButton button = new ToggleButton((UiContainer)content, "ON");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ToggleButton toggle = (ToggleButton)event.getSource();
                AutoLayoutPanel.this.setButtonText(toggle, toggle.isSelected());
                DesignerPreferences preferences = DesignerPreferences.getPreferences();
                preferences.setAutoLayout(toggle.isSelected());
                preferences.store();
            }
        });
        content.add((UiComponent)button, (Object)"growx, wrap");
        final CheckBox checkbox = CheckBox.create((UiContainer)content, (Msg)DesignerMsg.OPTIMIZE_LANES, (boolean)true);
        checkbox.addModificationListener(new ModificationListener(){

            public void objectModified(ModificationEvent event) {
                DesignerPreferences preferences = DesignerPreferences.getPreferences();
                boolean value = checkbox.isSelected();
                if (preferences.isOptimizeLanesOnAutoLayout() != value) {
                    preferences.setOptimizeLanesOnAutoLayout(value);
                }
            }
        });
        content.add((UiComponent)checkbox, (Object)"growx, wrap");
        Button run = new Button((UiContainer)content, new BaseAction(DesignerMsg.RUN_LAYOUT_ONCE){

            public void run() {
                LayoutModelCommand command = new LayoutModelCommand(AutoLayoutPanel.this.domain.getDomainElement(), Grid.createNull(), DesignerPreferences.getPreferences().isOptimizeLanesOnAutoLayout());
                ActionRunner.getInstance().run((Command)command);
                AutoLayoutPanel.this.domain.getCanvas().repaint();
            }
        });
        content.add((UiComponent)run);
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                Point screen = AutoLayoutPanel.this.getLocationOnScreen();
                if (content.getWidth() == 0) {
                    window.show(5000, 5000);
                }
                DesignerPreferences preferences = DesignerPreferences.getPreferences();
                AutoLayoutPanel.this.setButtonText(button, preferences.isAutoLayout());
                checkbox.setSelected(preferences.isOptimizeLanesOnAutoLayout());
                window.show(screen.getX() - content.getWidth() + AutoLayoutPanel.this.getWidth(), screen.getY());
            }
        });
    }

    private void setButtonText(@NotNull ToggleButton button, boolean selected) {
        button.setText(selected ? "ON" : "OFF");
        button.setSelected(selected);
    }
}

