/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.command.Command;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.execution.DefaultExecutionService;
import oracle.bpm.execution.Executable;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.execution.ExecutionService;
import oracle.bpm.execution.Interceptor;
import oracle.bpm.execution.InterceptorChain;
import oracle.bpm.project.ProjectObjectImpl;

public class ActionRunner {
    private ExecutionService executionService;
    private static ActionRunner instance;

    private ActionRunner() {
        DefaultExecutionService service = new DefaultExecutionService();
        service.addInterceptorByClass(new TransactionInterceptor(), Command.class);
        StudioWorkbench workbench = AbstractStudioWorkbench.getInstance();
        Interceptor commandInterceptor = workbench.getCommandInterceptor();
        if (commandInterceptor != null) {
            service.addInterceptorByClass(commandInterceptor, Command.class);
        }
        this.setExecutionService(service);
    }

    public static ActionRunner getInstance() {
        if (instance == null) {
            instance = new ActionRunner();
        }
        return instance;
    }

    public void addInterceptor(Interceptor interceptor) {
        this.getExecutionService().addInterceptor(interceptor);
    }

    public void run(Command command) {
        this.getExecutionService().execute(command);
    }

    private ExecutionService getExecutionService() {
        return this.executionService;
    }

    private void setExecutionService(ExecutionService executionService) {
        this.executionService = executionService;
    }

    static class TransactionInterceptor
    implements Interceptor {
        TransactionInterceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object execute(Executable executable, InterceptorChain chain) throws ExecutionException {
            Object result;
            Command command = (Command)executable;
            Object object = command.getAffectedObject();
            if (object instanceof ProjectObjectImpl) {
                ProjectObjectImpl po = (ProjectObjectImpl)object;
                ProjectObjectImpl lockable = (ProjectObjectImpl)po.getResourceObject();
                if (lockable == null) {
                    lockable = po;
                }
                try {
                    lockable.beginTransaction();
                    result = chain.proceed(executable);
                }
                finally {
                    lockable.endTransaction();
                }
            } else {
                result = chain.proceed(executable);
            }
            return result;
        }
    }
}

