/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.Iterator;
import oracle.bpm.designer.catalog.tree.ObjectMemberTreeNode;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.tree.TreeNode;

public abstract class AbstractTreeNode
extends TreeNode {
    public static final int DELETE = 1;
    public static final int OPEN = 2;
    public static final int REPORT = 4;
    public static final int EXPORT = 8;
    public static final int FIND = 16;
    public static final int HIDE = 32;
    public static final int SHOW = 64;
    private static final int[] MULTIPLE_ACTIONS = new int[]{2, 8, 16, 4, 1, 32, 64};

    public static int[] getMultipleActions() {
        return MULTIPLE_ACTIONS;
    }

    public BaseAction getActionForId(int actionId) {
        return null;
    }

    public AbstractTreeNode getFirst() {
        return (AbstractTreeNode)super.getFirstChild();
    }

    public boolean isLinkedNode() {
        return false;
    }

    public final AbstractTreeNode findChild(String name) {
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            AbstractTreeNode linkedNode;
            TreeNode child = (TreeNode)i$.next();
            if (!(child instanceof AbstractTreeNode)) continue;
            AbstractTreeNode childTreeNode = (AbstractTreeNode)child;
            if (name.equals(childTreeNode.getName())) {
                return childTreeNode;
            }
            if (childTreeNode.isLeaf() || !childTreeNode.isLinkedNode() || !name.equals((linkedNode = (AbstractTreeNode)childTreeNode.getChildAt(0)).getName())) continue;
            return linkedNode;
        }
        return null;
    }

    public final AbstractTreeNode findQualifiedChild(String qualifiedName) {
        return this.findQualifiedChild(qualifiedName, true);
    }

    public final AbstractTreeNode findQualifiedChild(String qualifiedName, boolean openCloseNodes) {
        AbstractTreeNode child;
        String name;
        int dot = qualifiedName.indexOf(46);
        String string = name = dot != -1 ? qualifiedName.substring(0, dot) : qualifiedName;
        if (openCloseNodes && !this.isLoaded()) {
            this.getChildCount();
        }
        if ((child = this.findChild(name)) != null) {
            if (dot == -1) {
                return child;
            }
            return child.findQualifiedChild(qualifiedName.substring(dot + 1), openCloseNodes);
        }
        return null;
    }

    public final AbstractTreeNode findOpenQualifiedChild(String qualifiedName) {
        return this.findQualifiedChild(qualifiedName, false);
    }

    public AbstractTreeNode getNext() {
        return (AbstractTreeNode)super.getNextSibling();
    }

    public AbstractTreeNode getPrevious() {
        return (AbstractTreeNode)super.getPreviousSibling();
    }

    public ObjectMemberTreeNode asObjectMemberTreeNode() {
        return null;
    }

    public ActionGroup createActions() {
        return ActionGroup.create((Object)((Object)this));
    }

    public void refresh() {
    }

    public void refresh(String qualifiedName) {
        int dot = qualifiedName.indexOf(46);
        String name = dot != -1 ? qualifiedName.substring(0, dot) : qualifiedName;
        AbstractTreeNode child = this.findChild(name);
        if (child != null) {
            if (dot == -1) {
                child.refresh();
            } else {
                child.refresh(qualifiedName.substring(dot + 1));
            }
        }
    }

    protected int getMultipleActionsMask() {
        return 0;
    }

    protected String getName() {
        return this.toString();
    }
}

