/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.designer.AbstractTypesBrowserModel;
import oracle.bpm.lang.Kind;
import oracle.bpm.type.AmbiguousTypeNameException;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeRef;

public abstract class AbstractTextTypeBrowserModelAdapter
extends AbstractTypesBrowserModel {
    private ComponentCatalog catalog;

    public AbstractTextTypeBrowserModelAdapter(ComponentCatalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public TypeRef getType() {
        try {
            String text = this.getStringValue();
            if (text == null) {
                return null;
            }
            int kind = Kind.getKind(text);
            if (Kind.isPredefined(kind) || kind == 15) {
                return null;
            }
            return this.catalog.find(text);
        }
        catch (AmbiguousTypeNameException e) {
            return null;
        }
    }

    protected abstract String getStringValue();

    protected abstract void setStringValue(String var1);

    @Override
    protected void innetSetType(TypeRef type) {
        this.setStringValue(type.getText());
    }
}

