/*
 * Decompiled with CFR 0.152.
 */
package fuego.parser;

import fuego.parser.Token;
import fuego.parser.TokenStream;
import fuego.parser.TokenStreamException;
import fuego.parser.TokenStreamRetryException;
import fuego.parser.collections.Stack;
import fuego.parser.collections.impl.LList;
import java.util.Hashtable;
import java.util.Map;

public class TokenStreamSelector
implements TokenStream {
    protected TokenStream input;
    protected Map<String, TokenStream> inputStreamNames;
    protected Stack streamStack = new LList();

    public TokenStreamSelector() {
        this.inputStreamNames = new Hashtable<String, TokenStream>();
    }

    public TokenStream getCurrentStream() {
        return this.input;
    }

    public TokenStream getStream(String sname) {
        TokenStream stream = this.inputStreamNames.get(sname);
        if (stream == null) {
            throw new IllegalArgumentException("TokenStream " + sname + " not found");
        }
        return stream;
    }

    public void addInputStream(TokenStream stream, String key) {
        this.inputStreamNames.put(key, stream);
    }

    @Override
    public Token nextToken() throws TokenStreamException {
        while (true) {
            try {
                return this.input.nextToken();
            }
            catch (TokenStreamRetryException tokenStreamRetryException) {
                continue;
            }
            break;
        }
    }

    public TokenStream pop() {
        TokenStream stream = (TokenStream)this.streamStack.pop();
        this.select(stream);
        return stream;
    }

    public void push(TokenStream stream) {
        this.streamStack.push(this.input);
        this.select(stream);
    }

    public void push(String sname) {
        this.streamStack.push(this.input);
        this.select(sname);
    }

    public void retry() throws TokenStreamRetryException {
        throw new TokenStreamRetryException();
    }

    public void select(TokenStream stream) {
        this.input = stream;
    }

    public void select(String sname) throws IllegalArgumentException {
        this.input = this.getStream(sname);
    }
}

