/*
 * Decompiled with CFR 0.152.
 */
package fuego.lexer;

import fuego.lexer.FuegoLexerInputStream;
import fuego.lexer.MultiCharTokenTable;
import fuego.parser.FuegoToken;
import fuego.parser.RecognitionException;
import fuego.parser.TokenStreamException;
import fuego.parser.TokenStreamRecognitionException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.lang.Cast;
import oracle.bpm.util.CharArrayMap;

public abstract class LexerConfigurator {
    protected final String version;
    private boolean[] caseInsensitive;
    private int escapeToken = -1;
    private MultiCharTokenTable[] multiCharTokenTables;
    private boolean noReservedWords;
    private CharArrayMap<Integer> persistentWords;
    private CharArrayMap<Integer>[] reservedWordsMaps;
    private int tokenNumber = 19;
    private Map<String, String>[] tokensByName;
    public static final int DEFAULT_STATE = 0;
    public static final int SQL_STATE = 1;
    public static final int MAX_STATE = 1;

    protected LexerConfigurator(String version) {
        this.version = version;
        this.caseInsensitive = new boolean[2];
        this.caseInsensitive[0] = false;
        this.caseInsensitive[1] = true;
    }

    public abstract String getLanguageName();

    public static boolean isCommentEnd(char c, FuegoLexerInputStream lexer) throws TokenStreamException {
        if (c == '*') {
            c = lexer.read();
            if (c == '/') {
                return true;
            }
            lexer.unread();
        }
        return false;
    }

    public static boolean isCommentStart(char c, FuegoLexerInputStream lexer) throws TokenStreamException {
        if (c == '/') {
            c = lexer.read();
            if (c == '*') {
                return true;
            }
            lexer.unread();
        }
        return false;
    }

    public static boolean isIdentifierPart(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    public static boolean isIdentifierStart(char c) {
        return Character.isJavaIdentifierStart(c) && c != '$';
    }

    public static boolean isReservedWordEscape(char c) {
        return c == '@';
    }

    public boolean[] getCaseInsensitiveByState() {
        return this.caseInsensitive;
    }

    public boolean isEscapeAfterToken(int type) throws TokenStreamException {
        if (this.escapeToken == -1) {
            this.escapeToken = this.getMultiCharTokens(0).find('.', null);
        }
        return this.escapeToken == type;
    }

    public char getEscapeForNewLine() {
        return '\uffff';
    }

    public boolean isLineCommentStart(char c, FuegoLexerInputStream lexer) throws TokenStreamException {
        if (c == '/') {
            c = lexer.read();
            if (c == '/') {
                return true;
            }
            lexer.unread();
        }
        return false;
    }

    public MultiCharTokenTable getMultiCharTokens(int state) {
        if (state < 0 || state > 1) {
            throw new RuntimeException("Invalid state number: " + state);
        }
        if (this.multiCharTokenTables == null) {
            this.initTokens();
        }
        return this.multiCharTokenTables[state];
    }

    public boolean isNewLineToken() {
        return false;
    }

    public Map getOperators(int state) {
        MultiCharTokenTable table = this.getMultiCharTokens(state);
        return table.getTokens();
    }

    public boolean isRegExpEnd(char c) {
        return c == '\'';
    }

    public boolean isRegExpStart(char c, FuegoLexerInputStream lexer) throws TokenStreamException {
        if (c == '\'') {
            c = lexer.read();
            if (c == '/') {
                return true;
            }
            lexer.unread();
        }
        return false;
    }

    public CharArrayMap<Integer> getReservedWords(int state) {
        if (state < 0 || state > 1) {
            throw new RuntimeException("Invalid state number: " + state);
        }
        if (this.reservedWordsMaps == null) {
            this.initTokens();
        }
        if (state == 0 && this.noReservedWords) {
            return this.persistentWords;
        }
        return this.reservedWordsMaps[state];
    }

    public boolean isStringDelimiter(char c, FuegoLexerInputStream lexer) throws TokenStreamException {
        return c == '\"';
    }

    public boolean isTimeLiteralDelimiter(char c) {
        return c == '\'';
    }

    public Map<String, String> getTokensByName(int state) {
        if (state < 0 || state > 1) {
            throw new RuntimeException("Invalid state number: " + state);
        }
        if (this.multiCharTokenTables == null) {
            this.initTokens();
        }
        return this.tokensByName[state];
    }

    public final String testRegExpEnd(char c, FuegoLexerInputStream lexer) throws TokenStreamException {
        if (c != '/') {
            return null;
        }
        StringBuilder result = new StringBuilder();
        while (!this.isRegExpEnd(c = lexer.read())) {
            if (c != 'i' && c != 'm' && c != 'g' && c != 's') {
                throw new TokenStreamRecognitionException(new RecognitionException("Illegal end of RegularExpression"));
            }
            result.append(c);
        }
        return result.toString();
    }

    public int numberSuffixType(char c) {
        return c == 'f' || c == 'F' || c == 'd' || c == 'D' ? 12 : -1;
    }

    public void dumpTokens(PrintWriter out) {
        for (String token : FuegoToken.builtInTokens) {
            int n = token.indexOf(58);
            int value = Integer.parseInt(token.substring(n + 1));
            token = token.substring(0, n);
            LexerConfigurator.dumpToken(out, token, value);
        }
        Map<String, Tk> tokens = this.initTokens();
        ArrayList<Map.Entry<String, Tk>> list = new ArrayList<Map.Entry<String, Tk>>(tokens.entrySet());
        Comparator<Map.Entry<String, Tk>> comparator = new Comparator<Map.Entry<String, Tk>>(){

            @Override
            public int compare(Map.Entry<String, Tk> o1, Map.Entry<String, Tk> o2) {
                return o1.getValue().value - o2.getValue().value;
            }
        };
        Collections.sort(list, comparator);
        for (Map.Entry entry : list) {
            Tk token = (Tk)entry.getValue();
            LexerConfigurator.dumpToken(out, (String)entry.getKey(), token.value);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setNoReservedWords(boolean value) {
        this.noReservedWords = value;
    }

    protected abstract String[][] getMultiCharTokensArrays(int var1);

    protected abstract String[][] getReservedWordsArrays(int var1);

    private static void dumpToken(PrintWriter out, String name, int value) {
        out.println(name + '=' + value);
    }

    private void assignTokens(boolean reservedWords, Map<String, Tk> all) {
        for (int state = 0; state <= 1; ++state) {
            String[][] words;
            if (reservedWords) {
                this.reservedWordsMaps[state] = new CharArrayMap();
                this.persistentWords = new CharArrayMap();
                words = this.getReservedWordsArrays(state);
            } else {
                this.multiCharTokenTables[state] = new MultiCharTokenTable();
                words = this.getMultiCharTokensArrays(state);
            }
            Map<String, String> tokensByName = this.tokensByName[state];
            if (tokensByName == null) {
                this.tokensByName[state] = tokensByName = new HashMap<String, String>();
            }
            String[][] arr$ = words;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String[] w;
                for (String word : w = arr$[i$]) {
                    String name;
                    boolean persistent;
                    if (reservedWords && word.startsWith("@")) {
                        persistent = true;
                        word = word.substring(1);
                    } else {
                        persistent = false;
                    }
                    int index = word.indexOf(58);
                    if (index != -1) {
                        name = word.substring(0, index);
                        word = word.substring(index + 1);
                    } else if (reservedWords) {
                        name = word.toUpperCase();
                    } else {
                        throw new RuntimeException("Invalid name for character Symbol : " + word);
                    }
                    Tk token = all.get(name);
                    tokensByName.put(name, word);
                    if (token == null) {
                        token = new Tk(word, ++this.tokenNumber);
                        all.put(name, token);
                    }
                    if (reservedWords) {
                        this.reservedWordsMaps[state].put(word, token.value);
                        if (!persistent) continue;
                        this.persistentWords.put(word, token.value);
                        continue;
                    }
                    this.multiCharTokenTables[state].add(word, token.value);
                }
            }
        }
    }

    private Map<String, Tk> initTokens() {
        HashMap<String, Tk> all = new HashMap<String, Tk>();
        this.tokensByName = (Map[])Cast.force(new Map[2]);
        this.reservedWordsMaps = (CharArrayMap[])Cast.force(new CharArrayMap[2]);
        this.assignTokens(true, all);
        this.multiCharTokenTables = new MultiCharTokenTable[2];
        this.assignTokens(false, all);
        return all;
    }

    private static class Tk {
        String text;
        int value;

        Tk(String text, int value) {
            this.text = text;
            this.value = value;
        }
    }
}

