/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.importer.wfmc.parser;

import java.util.LinkedHashSet;
import java.util.Set;
import oracle.bpm.project.importer.wfmc.parser.Text;
import oracle.bpm.xmlparser.DefaultElement;

public abstract class XPDLElement
extends DefaultElement {
    public abstract String getId();

    public String getTextContent() {
        String text = null;
        DefaultElement first = this.getFirstElement();
        if (first instanceof Text) {
            Text textNode = (Text)first;
            text = textNode.getContent();
        }
        return text;
    }

    public boolean containsAttribute(String attribute) {
        return this.getAttribute(attribute) != null;
    }

    public Set findAllDescendantsByClass(XPDLElement root, Class cl) {
        return this.findAllDescendantsByClass(root, cl, null);
    }

    public Set findAllDescendantsByClass(XPDLElement current, Class cl, Class filter) {
        LinkedHashSet resultSet = new LinkedHashSet();
        this.findDescendantByClass(current, resultSet, cl, filter);
        return resultSet;
    }

    public XPDLElement findChildByAttributeValueInAll(XPDLElement current, String attribute, String value) {
        return this.findChildByAttributeValueInAll(current, attribute, value, null);
    }

    public XPDLElement findChildByAttributeValueInAll(XPDLElement current, String attribute, String value, Class filter) {
        DefaultElement found = current.findChildByAttributeValue(attribute, value);
        if (found != null) {
            return (XPDLElement)found;
        }
        if (filter != null) {
            XPDLElement[] children = (XPDLElement[])current.findChildrenByClass(filter);
            for (int i = 0; i < children.length && (found = this.findChildByAttributeValueInAll(children[i], attribute, value, filter)) == null; ++i) {
            }
        } else {
            for (DefaultElement child = current.getFirstElement(); child != null && (found = this.findChildByAttributeValueInAll((XPDLElement)child, attribute, value, filter)) == null; child = child.getNextElement()) {
            }
        }
        return (XPDLElement)found;
    }

    public Set findChildrenByClassAsSet(Class cl) {
        LinkedHashSet<DefaultElement> children = new LinkedHashSet<DefaultElement>();
        for (DefaultElement current = this.getFirstElement(); current != null; current = current.getNextElement()) {
            if (!cl.isAssignableFrom(current.getClass())) continue;
            children.add(current);
        }
        return children;
    }

    protected String getAttrDefValue(String attribute, String value) {
        DefaultElement attrDef = this.findChildByAttributeValue(attribute, value);
        if (attrDef == null) {
            return null;
        }
        DefaultElement attrValue = attrDef.getFirstElement();
        DefaultElement textElem = attrValue.getFirstElement();
        return textElem.toString();
    }

    protected boolean hasNextElement() {
        return this.getNextElement() != null;
    }

    private void findDescendantByClass(XPDLElement current, Set resultSet, Class cl, Class filter) {
        XPDLElement[] children = (XPDLElement[])current.findChildrenByClass(cl);
        for (int i = 0; i < children.length; ++i) {
            resultSet.add(children[i]);
        }
        if (filter != null) {
            XPDLElement[] parents = (XPDLElement[])current.findChildrenByClass(filter);
            for (int i = 0; i < parents.length; ++i) {
                this.findDescendantByClass(parents[i], resultSet, cl, filter);
            }
        } else {
            for (XPDLElement element = (XPDLElement)current.getFirstElement(); element != null; element = (XPDLElement)element.getNextElement()) {
                this.findDescendantByClass(element, resultSet, cl, filter);
            }
        }
    }
}

