/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.importer.wfmc.parser;

import oracle.bpm.geom.Point;
import oracle.bpm.log.Log;
import oracle.bpm.project.importer.wfmc.parser.Description;
import oracle.bpm.project.importer.wfmc.parser.ExtendedAttribute;
import oracle.bpm.project.importer.wfmc.parser.ExtendedAttributes;
import oracle.bpm.project.importer.wfmc.parser.Implementation;
import oracle.bpm.project.importer.wfmc.parser.Join;
import oracle.bpm.project.importer.wfmc.parser.NoImplementation;
import oracle.bpm.project.importer.wfmc.parser.Performer;
import oracle.bpm.project.importer.wfmc.parser.RouteActivityType;
import oracle.bpm.project.importer.wfmc.parser.Split;
import oracle.bpm.project.importer.wfmc.parser.TransitionRestriction;
import oracle.bpm.project.importer.wfmc.parser.WfmcActivityType;
import oracle.bpm.project.importer.wfmc.parser.XPDLElement;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.xmlparser.DefaultElement;
import oracle.bpm.xmlparser.Element;

public class Activity
extends XPDLElement {
    private ExtendedAttributes extAttributes;
    private XPDLElement transRestrictions;
    static final String ID = "Id";
    static final String NAME = "Name";

    public Activity() {
        this.setTagName("Activity");
    }

    public WfmcActivityType getActivityType() {
        DefaultElement activityType = this.findChildByClass(WfmcActivityType.class);
        if (activityType != null) {
            return (WfmcActivityType)activityType;
        }
        return new RouteActivityType();
    }

    public boolean isAutomatic() {
        DefaultElement startMode = this.findChildByName("StartMode");
        if (startMode != null) {
            return startMode.findChildByName("Automatic") != null;
        }
        return true;
    }

    public String getDescription() {
        XPDLElement descriptionElement = (XPDLElement)this.findChildByClass(Description.class);
        if (descriptionElement != null) {
            return descriptionElement.getTextContent();
        }
        return "";
    }

    public ExtendedAttribute[] getExtendedAttributes() {
        return this.getExtAttributes().getExtendedAttributes();
    }

    @Override
    public String getId() {
        return this.getAttribute(ID);
    }

    public Implementation getImplementation() {
        Implementation imp = (Implementation)this.findChildByClass(Implementation.class);
        if (imp != null && (imp = (Implementation)imp.findChildByClass(Implementation.class)) != null) {
            return imp;
        }
        return new NoImplementation();
    }

    public Join getJoin() {
        TransitionRestriction[] transitionRestrictions = this.getTransitionRestrictions();
        for (int i = 0; i < transitionRestrictions.length; ++i) {
            TransitionRestriction transitionRestriction = transitionRestrictions[i];
            Join join = transitionRestriction.getJoin();
            if (join == null) continue;
            return join;
        }
        return null;
    }

    public Point getLocation() {
        return this.getXY();
    }

    public String getName() {
        return this.getAttribute(NAME);
    }

    public String getParticipant() {
        ExtendedAttribute att = this.getExtendedAttributeByName("ParticipantID");
        if (att != null) {
            return att.getAttribute("Value");
        }
        Performer performer = (Performer)this.findChildByClass(Performer.class);
        if (performer != null) {
            return performer.getTextContent();
        }
        return "";
    }

    public Split getSplit() {
        TransitionRestriction[] transitionRestrictions = this.getTransitionRestrictions();
        for (int i = 0; i < transitionRestrictions.length; ++i) {
            TransitionRestriction transitionRestriction = transitionRestrictions[i];
            Split split = transitionRestriction.getSplit();
            if (split == null) continue;
            return split;
        }
        return null;
    }

    public TransitionRestriction[] getTransitionRestrictions() {
        if (this.transRestrictions == null) {
            this.transRestrictions = (XPDLElement)this.findChildByName("TransitionRestrictions");
        }
        if (this.transRestrictions != null) {
            return (TransitionRestriction[])this.transRestrictions.findChildrenByClass(TransitionRestriction.class);
        }
        return new TransitionRestriction[0];
    }

    public Point getXY() {
        ExtendedAttribute xOffset = this.getExtendedAttributeByName("XOffset");
        int xpos = 0;
        int ypos = 0;
        if (xOffset != null) {
            ExtendedAttribute yOffset = this.getExtendedAttributeByName("YOffset");
            xpos = Integer.valueOf(xOffset.getAttribute("Value"));
            if (yOffset != null) {
                ypos = Integer.valueOf(yOffset.getAttribute("Value"));
            }
        } else {
            DefaultElement childByName = this.findChildByName("Coordinates");
            if (childByName != null) {
                xpos = Integer.valueOf(childByName.getAttribute("xpos"));
                ypos = Integer.valueOf(childByName.getAttribute("ypos"));
            } else {
                Log.logWarning((Msg)UIMsg.TO_MSG((String)("Activity " + this.getId() + " name = " + this.getName() + " has no coordinates")));
            }
        }
        return new Point(xpos, ypos);
    }

    public void addExtendedAttribute(ExtendedAttribute att) {
        this.getExtAttributes().addChild((Element)att);
    }

    private ExtendedAttributes getExtAttributes() {
        if (this.extAttributes == null) {
            this.extAttributes = (ExtendedAttributes)this.findChildByClass(ExtendedAttributes.class);
            if (this.extAttributes == null) {
                this.extAttributes = new ExtendedAttributes();
                this.addChild((Element)this.extAttributes);
            }
        }
        return this.extAttributes;
    }

    private ExtendedAttribute getExtendedAttributeByName(String name) {
        ExtendedAttribute att = (ExtendedAttribute)this.getExtAttributes().findChildByAttributeValue(NAME, name);
        return att;
    }
}

