/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.importer.aris;

import java.util.HashMap;
import java.util.Map;
import oracle.bpm.processmodel.ActivityType;
import oracle.bpm.project.importer.ImportRuleActivity;
import oracle.bpm.project.importer.ImportRuleSet;
import oracle.bpm.project.importer.aris.ArisActivityType;
import oracle.bpm.project.importer.aris.parser.Definition;
import oracle.bpm.project.importer.aris.parser.Model;
import oracle.bpm.project.importer.aris.parser.Occurrence;

public class ObjMapper {
    static final ImportRuleActivity AUTOMATIC_ACTIVITY_RULE = new ImportRuleActivity(ActivityType.AUTOMATIC);
    static final ImportRuleActivity SUBFLOW_ACTIVITY_RULE = new ImportRuleActivity(ActivityType.SUBFLOW);

    public static ArisActivityType getArisType(String type, String subType) {
        if (type == null) {
            return null;
        }
        if (type.equals("OT_FUNC")) {
            return ObjMapper.getFunctionType(subType);
        }
        if (type.equals("OT_ACTION")) {
            return ArisActivityType.OT_ACTION;
        }
        if (type.equals("OT_EVT")) {
            return ArisActivityType.OT_EVT;
        }
        if (type.equals("OT_PARTITION")) {
            return ArisActivityType.OT_PARTITION;
        }
        if (type.equals("OT_PERF")) {
            return ArisActivityType.OT_PERF;
        }
        if (type.equals("OT_RULE")) {
            return ObjMapper.getRuleType(subType);
        }
        if (type.equals("OT_TECH_TRM")) {
            return ArisActivityType.OT_TECH_TRM;
        }
        if (type.equals("OT_CLS")) {
            return ArisActivityType.OT_CLS;
        }
        if (type.equals("OT_CLST")) {
            return ArisActivityType.OT_CLST;
        }
        if (type.equals("OT_ENT_TYPE")) {
            return ArisActivityType.OT_ENT_TYPE;
        }
        if (type.equals("OT_INFO_CARR")) {
            return ArisActivityType.OT_INFO_CARR;
        }
        if (type.equals("OT_KNWLDG_CAT")) {
            return ArisActivityType.OT_KNWLDG_CAT;
        }
        if (type.equals("OT_POS")) {
            return ArisActivityType.OT_POS;
        }
        if (type.equals("OT_ORG_UNIT")) {
            return ObjMapper.getOrgUnitType(subType);
        }
        if (type.equals("OT_ORG_UNIT_TYPE")) {
            return ObjMapper.getOrgUnitTypeType(subType);
        }
        if (type.equals("OT_PERS")) {
            return ObjMapper.getPersonType(subType);
        }
        if (type.equals("OT_PERS_TYPE")) {
            return ArisActivityType.OT_PERS_TYPE;
        }
        if (type.equals("OT_PACK")) {
            return ArisActivityType.OT_PACK;
        }
        if (type.equals("OT_ERM_ATTR")) {
            return ObjMapper.getEntityModelType(subType);
        }
        return null;
    }

    public static ImportRuleSet getDefaultRules() {
        ImportRuleSet ruleSet = ImportRuleSet.create();
        Map rules = ruleSet.getRules();
        ObjMapper.addFunctionRules(rules);
        rules.put(ArisActivityType.OT_ACTION.toString(), AUTOMATIC_ACTIVITY_RULE);
        rules.put(ArisActivityType.OT_EVT.toString(), AUTOMATIC_ACTIVITY_RULE);
        rules.put(ArisActivityType.OT_PARTITION.toString(), ImportRuleActivity.SKIP_SHAPE);
        rules.put(ArisActivityType.OT_PERF.toString(), ImportRuleActivity.SKIP_SHAPE);
        rules.put(ArisActivityType.OT_RULE_ST_OPR_AND_1.toString(), new ImportRuleActivity(ActivityType.SPLIT));
        rules.put(ArisActivityType.OT_RULE_ST_OPR_XOR_1.toString(), new ImportRuleActivity(ActivityType.CONDITIONAL));
        rules.put(ArisActivityType.OT_RULE_ST_OPR_OR_1.toString(), new ImportRuleActivity(ActivityType.CONDITIONAL));
        rules.put(ArisActivityType.OT_TECH_TRM.toString(), ImportRuleActivity.SKIP_SHAPE);
        rules.put(ArisActivityType.OT_CLS.toString(), ImportRuleActivity.SKIP_SHAPE);
        rules.put(ArisActivityType.OT_CLST.toString(), ImportRuleActivity.SKIP_SHAPE);
        rules.put(ArisActivityType.OT_ENT_TYPE.toString(), ImportRuleActivity.SKIP_SHAPE);
        rules.put(ArisActivityType.OT_INFO_CARR.toString(), ImportRuleActivity.SKIP_SHAPE);
        rules.put(ArisActivityType.OT_KNWLDG_CAT.toString(), ImportRuleActivity.SKIP_SHAPE);
        ObjMapper.addOrganizationRules(rules);
        rules.put(ArisActivityType.OT_PACK.toString(), ImportRuleActivity.SKIP_SHAPE);
        rules.put(ArisActivityType.OT_ERM_ATTR.toString(), ImportRuleActivity.SKIP_SHAPE);
        rules.put(ArisActivityType.OT_ERM_ATTR_ST_ATTR_3.toString(), ImportRuleActivity.SKIP_SHAPE);
        return ruleSet;
    }

    public static ImportRuleSet getDefaultRules(Model[] models, ImportRuleSet preferencesImportRules) {
        Map ruleTemplate = ObjMapper.getDefaultRules().getRules();
        if (preferencesImportRules != null) {
            ruleTemplate.putAll(preferencesImportRules.getRules());
        }
        ImportRuleSet rules = ImportRuleSet.create();
        for (int i = 0; i < models.length; ++i) {
            Model model = models[i];
            Occurrence[] occurrences = model.getOccurrences();
            for (int j = 0; j < occurrences.length; ++j) {
                ImportRuleActivity rule;
                String subType;
                Occurrence occurrence = occurrences[j];
                if (occurrence.isText()) continue;
                String reference = occurrence.getDefIdRef();
                assert (reference != null) : "Invalid reference for occurrence '" + occurrence.getId() + "'";
                Definition definition = occurrence.getDefinition();
                assert (definition != null) : "Could not definition for id '" + reference + "'";
                String type = definition.getType();
                ArisActivityType arisType = ObjMapper.getArisType(type, subType = occurrence.getSymbol());
                if (arisType != null) {
                    rule = (ImportRuleActivity)ruleTemplate.get(arisType.name());
                    rules.addRule(arisType.name(), rule != null ? rule : ImportRuleActivity.SKIP_SHAPE);
                    continue;
                }
                if (type == null || type.equals("")) continue;
                rule = (ImportRuleActivity)ruleTemplate.get(type);
                rules.addRule(type, rule != null ? rule : ImportRuleActivity.SKIP_SHAPE);
            }
        }
        return rules;
    }

    public static Map getOccRulesFor(Model model, Map rulesMap) {
        HashMap<Occurrence, ImportRuleActivity> resultMap = new HashMap<Occurrence, ImportRuleActivity>();
        Occurrence[] occurrences = model.getOccurrences();
        for (int j = 0; j < occurrences.length; ++j) {
            ImportRuleActivity rule;
            String subType;
            Occurrence occurrence = occurrences[j];
            String reference = occurrence.getDefIdRef();
            assert (reference != null) : "Invalid reference for occurrence '" + occurrence.getId() + "'";
            Definition definition = occurrence.getDefinition();
            assert (definition != null) : "Could not definition for id '" + reference + "'";
            String type = definition.getType();
            ArisActivityType arisType = ObjMapper.getArisType(type, subType = occurrence.getSymbol());
            ImportRuleActivity importRuleActivity = rule = arisType != null ? (ImportRuleActivity)rulesMap.get(arisType.name()) : ImportRuleActivity.SKIP_SHAPE;
            assert (rule != null) : "Could not find rule for occurrence '" + occurrence.getId() + "'" + " with type '" + (arisType != null ? arisType.name() : type + ":" + subType) + "'";
            resultMap.put(occurrence, rule);
        }
        return resultMap;
    }

    public static void main(String[] args) {
    }

    private static void addFunctionRules(Map rules) {
        rules.put(ArisActivityType.OT_FUNC_ST_FUNC.toString(), AUTOMATIC_ACTIVITY_RULE);
        rules.put(ArisActivityType.OT_FUNC_ST_FUNC_ACT.toString(), AUTOMATIC_ACTIVITY_RULE);
        rules.put(ArisActivityType.OT_FUNC_ST_FUNC_TRG.toString(), AUTOMATIC_ACTIVITY_RULE);
        rules.put(ArisActivityType.OT_FUNC_ST_PRCS_IF.toString(), SUBFLOW_ACTIVITY_RULE);
        rules.put(ArisActivityType.OT_FUNC_ST_SYS_FUNC_ACT.toString(), SUBFLOW_ACTIVITY_RULE);
        rules.put(ArisActivityType.OT_FUNC_ST_SYS_FUNC_TRG.toString(), SUBFLOW_ACTIVITY_RULE);
        rules.put(ArisActivityType.OT_FUNC_ST_PRCS_MOD.toString(), SUBFLOW_ACTIVITY_RULE);
    }

    private static void addOrganizationRules(Map rules) {
        rules.put(ArisActivityType.OT_POS.toString(), ImportRuleActivity.ROLE);
        rules.put(ArisActivityType.OT_ORG_UNIT.toString(), ImportRuleActivity.ROLE);
        rules.put(ArisActivityType.OT_ORG_UNIT_ST_ORG_UNIT_1.toString(), ImportRuleActivity.ROLE);
        rules.put(ArisActivityType.OT_ORG_UNIT_ST_ORG_UNIT_2.toString(), ImportRuleActivity.ROLE);
        rules.put(ArisActivityType.OT_ORG_UNIT_TYPE_ST_ORG_UNIT_TYPE_1.toString(), ImportRuleActivity.ROLE);
        rules.put(ArisActivityType.OT_ORG_UNIT_TYPE_ST_ORG_UNIT_TYPE_2.toString(), ImportRuleActivity.ROLE);
        rules.put(ArisActivityType.OT_ORG_UNIT_TYPE_ST_POS_TYPE.toString(), ImportRuleActivity.ROLE);
        rules.put(ArisActivityType.OT_PERS_ST_PERS_INT.toString(), ImportRuleActivity.ROLE);
        rules.put(ArisActivityType.OT_PERS_ST_PERS_EXT.toString(), ImportRuleActivity.ROLE);
        rules.put(ArisActivityType.OT_PERS_TYPE_ST_EMPL_TYPE.toString(), ImportRuleActivity.ROLE);
        rules.put(ArisActivityType.OT_PERS_TYPE_ST_JOB_DESC.toString(), ImportRuleActivity.NOTE);
        rules.put(ArisActivityType.OT_PERS_TYPE_ST_EMPL_INST.toString(), ImportRuleActivity.ROLE);
        rules.put(ArisActivityType.OT_PERS_TYPE.toString(), ImportRuleActivity.ROLE);
    }

    private static ArisActivityType getEntityModelType(String subType) {
        ArisActivityType type = ArisActivityType.OT_ERM_ATTR;
        if (subType != null) {
            if (subType.equals("ST_ATTR_3")) {
                type = ArisActivityType.OT_ERM_ATTR_ST_ATTR_3;
            } else {
                ObjMapper.warnSubtype("OT_ERM_ATTR", subType);
            }
        }
        return type;
    }

    private static ArisActivityType getFunctionType(String subType) {
        ArisActivityType type = ArisActivityType.OT_FUNC;
        if (subType != null) {
            if (subType.equals("ST_FUNC")) {
                type = ArisActivityType.OT_FUNC_ST_FUNC;
            } else if (subType.equals("ST_FUNC_ACT")) {
                type = ArisActivityType.OT_FUNC_ST_FUNC_ACT;
            } else if (subType.equals("ST_FUNC_TRG")) {
                type = ArisActivityType.OT_FUNC_ST_FUNC_TRG;
            } else if (subType.equals("ST_PRCS_IF")) {
                type = ArisActivityType.OT_FUNC_ST_PRCS_IF;
            } else if (subType.equals("ST_PRCS_MOD")) {
                type = ArisActivityType.OT_FUNC_ST_PRCS_MOD;
            } else if (subType.equals("ST_SYS_FUNC_ACT")) {
                type = ArisActivityType.OT_FUNC_ST_SYS_FUNC_ACT;
            } else if (subType.equals("ST_SYS_FUNC_TRG")) {
                type = ArisActivityType.OT_FUNC_ST_SYS_FUNC_TRG;
            } else {
                ObjMapper.warnSubtype("OT_FUNC", subType);
            }
        }
        return type;
    }

    private static ArisActivityType getOrgUnitType(String subType) {
        ArisActivityType type = ArisActivityType.OT_ORG_UNIT;
        if (subType != null) {
            if (subType.equals("ST_ORG_UNIT_1")) {
                return ArisActivityType.OT_ORG_UNIT_ST_ORG_UNIT_1;
            }
            if (subType.equals("ST_ORG_UNIT_2")) {
                return ArisActivityType.OT_ORG_UNIT_ST_ORG_UNIT_2;
            }
            ObjMapper.warnSubtype("OT_ORG_UNIT", subType);
        }
        return type;
    }

    private static ArisActivityType getOrgUnitTypeType(String subType) {
        ArisActivityType type = ArisActivityType.OT_ORG_UNIT_TYPE;
        if (subType != null) {
            if (subType.equals("ST_ORG_UNIT_TYPE_1")) {
                type = ArisActivityType.OT_ORG_UNIT_TYPE_ST_ORG_UNIT_TYPE_1;
            } else if (subType.equals("ST_ORG_UNIT_TYPE_2")) {
                type = ArisActivityType.OT_ORG_UNIT_TYPE_ST_ORG_UNIT_TYPE_2;
            } else if (subType.equals("ST_POS_TYPE")) {
                type = ArisActivityType.OT_ORG_UNIT_TYPE_ST_POS_TYPE;
            } else {
                ObjMapper.warnSubtype("OT_ORG_UNIT_TYPE", subType);
            }
        }
        return type;
    }

    private static ArisActivityType getPersonType(String subType) {
        ArisActivityType type = ArisActivityType.OT_PERS;
        if (subType != null) {
            if (subType.equals("ST_PERS_INT")) {
                type = ArisActivityType.OT_PERS_ST_PERS_INT;
            } else if (subType.equals("ST_PERS_EXT")) {
                type = ArisActivityType.OT_PERS_ST_PERS_EXT;
            } else if (subType.equals("ST_EMPL_TYPE")) {
                type = ArisActivityType.OT_PERS_TYPE_ST_EMPL_TYPE;
            } else if (subType.equals("ST_JOB_DESC")) {
                type = ArisActivityType.OT_PERS_TYPE_ST_JOB_DESC;
            } else if (subType.equals("ST_EMPL_INST")) {
                type = ArisActivityType.OT_PERS_TYPE_ST_EMPL_INST;
            } else {
                ObjMapper.warnSubtype("OT_PERS", subType);
            }
        }
        return type;
    }

    private static ArisActivityType getRuleType(String subType) {
        ArisActivityType type = ArisActivityType.OT_RULE;
        if (subType != null) {
            if (subType.equals("ST_OPR_AND_1")) {
                type = ArisActivityType.OT_RULE_ST_OPR_AND_1;
            } else if (subType.equals("ST_OPR_OR_1")) {
                type = ArisActivityType.OT_RULE_ST_OPR_OR_1;
            } else if (subType.equals("ST_OPR_XOR_1")) {
                type = ArisActivityType.OT_RULE_ST_OPR_XOR_1;
            } else {
                ObjMapper.warnSubtype("OT_RULE", subType);
            }
        }
        return type;
    }

    private static void warn(String message) {
        System.err.println("[warn-objmapper] : " + message);
    }

    private static void warnSubtype(String type, String subType) {
        ObjMapper.warn("Invalid subType '" + subType + "' for '" + type + "'");
    }
}

