/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.importer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.extension.ExtensionService;
import oracle.bpm.extensionpoint.metadata.ModelImporterMetadata;
import oracle.bpm.lang.Platform;
import oracle.bpm.project.importer.CancelActionException;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.util.FileFilter;

public interface ModelImporter {
    public Type getType();

    public String getAssociatedExtension();

    public FileFilter getFileFilter();

    public Collection<Process> importModels(File var1, Project var2) throws ProjectException, CancelActionException;

    public void afterImport(Process[] var1) throws ProjectException;

    public static class Extension {
        public static List<ModelImporter> getImporters() {
            ArrayList<ModelImporter> result = new ArrayList<ModelImporter>();
            ExtensionService extensionService = Platform.getExtensionService();
            List extensions = extensionService.getExtensionsByPoint(ModelImporterMetadata.class);
            for (oracle.bpm.extension.Extension extension : extensions) {
                try {
                    ModelImporter importer = (ModelImporter)extension.instantiateAs(ModelImporter.class);
                    result.add(importer);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
            }
            return result;
        }
    }

    public static enum Type {
        ARIS,
        BPEL,
        ROSE,
        VISIO,
        XPDL_10;

    }
}

