/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.importer;

import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import oracle.bpm.processmodel.ActivityType;
import oracle.bpm.project.importer.ImportRuleActivity;
import org.xml.sax.Attributes;

public final class ImportRuleSet {
    private final SortedMap<String, ImportRuleActivity> rules = new TreeMap<String, ImportRuleActivity>();

    private ImportRuleSet() {
    }

    public static ImportRuleSet create() {
        return new ImportRuleSet();
    }

    public void addAll(ImportRuleSet rulesToAdd) {
        if (rulesToAdd != null) {
            this.rules.putAll(rulesToAdd.rules);
        }
    }

    public void addAsUndefined(SortedSet shapeNames) {
        for (String shape : shapeNames) {
            this.rules.put(shape, ImportRuleActivity.NOT_DEFINED);
        }
    }

    public void addRule(Attributes amap) {
        String shape = amap.getValue("shape");
        String activityTypeString = amap.getValue("activityType");
        if (activityTypeString != null) {
            this.addRule(shape, activityTypeString);
        }
    }

    public void addRule(String shapeName, ImportRuleActivity importRuleActivity) {
        this.rules.put(shapeName, importRuleActivity);
    }

    public void addRule(String shapeName, ActivityType type) {
        this.rules.put(shapeName, new ImportRuleActivity(type));
    }

    public void addRuleFromExternalName(String shape, String externalTypeName) {
        this.rules.put(shape, ImportRuleActivity.createFromExternal(externalTypeName));
    }

    public void addSkip(String shape) {
        this.rules.put(shape, ImportRuleActivity.SKIP_SHAPE);
    }

    public void addUndefined(String shape) {
        this.rules.put(shape, ImportRuleActivity.NOT_DEFINED);
    }

    public boolean allDefined() {
        return !this.rules.values().contains(ImportRuleActivity.NOT_DEFINED);
    }

    public ImportRuleActivity[] getActivities() {
        ImportRuleActivity[] result = new ImportRuleActivity[this.rules.size()];
        this.rules.values().toArray(result);
        return result;
    }

    public ImportRuleActivity getActivityType(String shapeName) {
        return (ImportRuleActivity)this.rules.get(shapeName);
    }

    public Map getRules() {
        return this.rules;
    }

    public String[] getShapes() {
        String[] result = new String[this.rules.size()];
        this.rules.keySet().toArray(result);
        return result;
    }

    private void addRule(String shapeName, String activityName) {
        this.rules.put(shapeName, ImportRuleActivity.valueOf(activityName));
    }
}

