/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.ui.wizards;

import java.util.List;
import oracle.bpm.lang.InputValidationException;
import oracle.bpm.project.io.fs.export.ProjectZipper;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.ui.validators.ImportFuegoProjectValidator;
import oracle.bpm.project.ui.wizards.ImportProjectWizardUserObject;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.forms.FormsFactory;
import oracle.bpm.ui.forms.StandardForm;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.wizards.model.Wizard;
import oracle.bpm.ui.wizards.model.WizardStep;
import oracle.bpm.ui.wizards.ui.WizardStepPanel;

public class ProjectNameStep
extends WizardStep {
    private ProjectNamePanel projectNamePanel;

    public ProjectNameStep(Wizard owner) {
        super(owner);
    }

    @Override
    public WizardStepPanel getPanelFor(UiContainer parent) {
        this.projectNamePanel = new ProjectNamePanel(parent, this);
        return this.projectNamePanel;
    }

    @Override
    public boolean doProcess() {
        ((ImportProjectWizardUserObject)((Wizard)this.getWizard()).getUserObject()).getEntries().get(0).setProjectName(this.projectNamePanel.projectNameTextField.getText());
        return true;
    }

    @Override
    public void undoProcess() {
    }

    private static class ProjectNamePanel
    extends WizardStepPanel {
        private TextField projectNameTextField;

        public ProjectNamePanel(UiContainer parent, WizardStep wizardStep) {
            super(parent, wizardStep);
        }

        @Override
        public UiComponent createCenterPage(UiContainer parent) {
            this.setPageTitle(ProjectMsg.PROJECT_NAME_TITLE);
            this.setPageDesc(ProjectMsg.PROJECT_NAME_DESCR);
            Panel centerPanel = new Panel(parent);
            StandardForm layout = FormsFactory.createStandardForm(centerPanel);
            Label projectNameLabel = Label.create((UiContainer)centerPanel, ProjectMsg.PROJECT_NAME);
            this.projectNameTextField = new TextField(centerPanel);
            layout.add(projectNameLabel);
            layout.add(this.projectNameTextField);
            return centerPanel;
        }

        @Override
        public void onFocus() {
            Object wizard = this.getWizardStep().getWizard();
            List<ProjectZipper.Entry> entries = ((ImportProjectWizardUserObject)((Wizard)wizard).getUserObject()).getEntries();
            if (entries.size() == 1) {
                ProjectZipper.Entry entry = entries.get(0);
                this.projectNameTextField.setText(entry.getProjectName());
            }
        }

        @Override
        public boolean validateInput() {
            ImportFuegoProjectValidator validator = new ImportFuegoProjectValidator();
            try {
                validator.validate(this.projectNameTextField.getText());
            }
            catch (InputValidationException e) {
                MessageDialog.showError(e.getKey());
                return false;
            }
            return true;
        }
    }
}

