/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.ui.wizards;

import java.io.File;
import oracle.bpm.project.io.UnzipListener;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.ui.wizards.ImportProjectWizardUserObject;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.wizards.model.WizardStep;

class ProjectImportRunnable
implements Runnable {
    private UnzipListener listener;
    private ImportProjectWizardUserObject wizardUserObject;

    public ProjectImportRunnable(WizardStep step, ImportProjectWizardUserObject wizardUserObject, UnzipListener listener) {
        this.wizardUserObject = wizardUserObject;
        this.listener = listener;
    }

    @Override
    public void run() {
        try {
            this.listener.info(ProjectMsg.PROCESSING_FILES.toString());
            ProjectRepository repository = RepositoryService.getInstance().getActiveRepository();
            for (File unzippedProjectFile : this.wizardUserObject.getProjectFiles()) {
                Project project = repository.create(unzippedProjectFile.getParentFile().toURI(), unzippedProjectFile.getName());
                this.listener.info(ProjectMsg.PROCESSING_COMPLETED.toString());
            }
        }
        catch (ProjectException e) {
            MessageDialog.showError(e);
        }
        catch (Exception unexpected) {
            unexpected.printStackTrace();
            MessageDialog.showError(unexpected);
        }
    }
}

