/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.ui.wizards;

import java.io.File;
import oracle.bpm.geom.Insets;
import oracle.bpm.project.io.FileSystemTokens;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.ui.ProjectChooser;
import oracle.bpm.project.ui.wizards.ImportWizardUserObject;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.GridBagConstraints;
import oracle.bpm.ui.layout.GridBagLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.wizards.model.Wizard;
import oracle.bpm.ui.wizards.model.WizardStep;
import oracle.bpm.ui.wizards.ui.WizardStepPanel;

class LocalProjectStep
extends WizardStep {
    private LocalProjectPanel localProjectPanel;

    public LocalProjectStep(Wizard owner) {
        super(owner);
    }

    @Override
    public WizardStepPanel getPanelFor(UiContainer parent) {
        if (this.localProjectPanel == null) {
            this.localProjectPanel = new LocalProjectPanel(parent, this);
        }
        return this.localProjectPanel;
    }

    @Override
    public boolean doProcess() {
        ((ImportWizardUserObject)((Wizard)this.getWizard()).getUserObject()).setProjectFile(this.localProjectPanel.getSelectedFile());
        ((ImportWizardUserObject)((Wizard)this.getWizard()).getUserObject()).setProjectName(this.localProjectPanel.getSelectedFile().getName());
        return true;
    }

    @Override
    public void undoProcess() {
    }

    private static class LocalProjectPanel
    extends WizardStepPanel {
        private Button browseButton;
        private TextField projectField;

        LocalProjectPanel(UiContainer parent, WizardStep wizardStep) {
            super(parent, wizardStep);
        }

        @Override
        public boolean validateInput() {
            File projectFile = this.getSelectedFile();
            if (!projectFile.exists() || !projectFile.isDirectory()) {
                MessageDialog.showError(ProjectMsg.FILE_NOT_FOUND((String)projectFile.getPath()));
                return false;
            }
            if (!FileSystemTokens.isValidProject((File)projectFile)) {
                MessageDialog.showError(ProjectMsg.INVALID_PROJECT_FILE((String)projectFile.getPath()));
                return false;
            }
            return true;
        }

        protected String getProjectDirValue() {
            File projectFile = ((ImportWizardUserObject)((Wizard)this.getWizardStep().getWizard()).getUserObject()).getProjectFile();
            if (projectFile == null) {
                projectFile = FileSystemTokens.getDefaultProjectsDir();
            }
            return projectFile.getPath();
        }

        @Override
        protected UiComponent createCenterPage(UiContainer parent) {
            this.setPageTitle(ProjectMsg.PROJECT_LOCATION_TITLE);
            this.setPageDesc(ProjectMsg.SELECT_PROJECT);
            Panel panel = new Panel(parent);
            panel.setLayout(new GridBagLayout());
            Label projectLabel = Label.create((UiContainer)panel, ProjectModelMsg.PROJECT);
            this.projectField = new TextField((UiContainer)panel, this.getProjectDirValue());
            this.browseButton = new Button((UiContainer)panel, UIMsg.BROWSE);
            this.browseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LocalProjectPanel.this.showFileChooser();
                }
            });
            panel.add(projectLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
            panel.add(this.projectField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 0, 10), 0, 0));
            panel.add(this.browseButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 10), 0, 0));
            this.browseButton.requestFocus();
            return panel;
        }

        private File getSelectedFile() {
            return new File(this.projectField.getText());
        }

        private void showFileChooser() {
            ProjectChooser projectChooser = ProjectChooser.create();
            int result = projectChooser.show(null);
            if (projectChooser.getSelectedFile() == null) {
                return;
            }
            if (result == 0) {
                String location = projectChooser.getSelectedFile().getAbsolutePath();
                this.projectField.setText(location);
            }
        }
    }
}

