/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.ui.wizards;

import oracle.bpm.lang.Str;
import oracle.bpm.project.io.fs.export.ExportType;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.ui.msg.ProjectUiMsg;
import oracle.bpm.project.ui.wizards.ImportWizardUserObject;
import oracle.bpm.project.ui.wizards.ProjectKeeper;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.BoxLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.wizards.model.Wizard;
import oracle.bpm.ui.wizards.model.WizardStep;
import oracle.bpm.ui.wizards.ui.WizardStepPanel;
import oracle.bpm.util.CommonPreferences;

public class ExportTypeStep
extends WizardStep {
    private ProjectKeeper projectKeeper;
    private ExportTypePanel typePanel;

    public ExportTypeStep(Wizard wizard, ProjectKeeper projectKeeper) {
        super(wizard);
        this.projectKeeper = projectKeeper;
    }

    @Override
    public boolean doProcess() {
        ImportWizardUserObject wizardUserObject = (ImportWizardUserObject)((Wizard)this.getWizard()).getUserObject();
        wizardUserObject.setExportType(this.typePanel.getSelectedType());
        wizardUserObject.setIncludeDependencies(this.typePanel.includeDependencies());
        if (!this.typePanel.getSelectedType().getName().equals(CommonPreferences.getInstance().getLastExportedType())) {
            CommonPreferences.getInstance().setLastExportedType(this.typePanel.getSelectedType().getName());
            CommonPreferences.getInstance().store();
        }
        return true;
    }

    public ProjectKeeper getProjectKeeper() {
        return this.projectKeeper;
    }

    @Override
    public void undoProcess() {
    }

    @Override
    protected WizardStepPanel getPanelFor(UiContainer parent) {
        if (this.typePanel == null) {
            this.typePanel = new ExportTypePanel(parent, this);
        }
        return this.typePanel;
    }

    protected static class ExportTypePanel
    extends WizardStepPanel {
        private ButtonGroup<RadioButton<ExportType>> buttonGroup;
        private CheckBox includeDependenciesCheckBox;

        public ExportTypePanel(UiContainer parent, WizardStep wizardStep) {
            super(parent, wizardStep);
        }

        public ExportType getSelectedType() {
            return this.buttonGroup.getSelection().getItem();
        }

        public boolean includeDependencies() {
            return this.includeDependenciesCheckBox.isSelected();
        }

        @Override
        public boolean validateInput() {
            Project dependency;
            boolean result = true;
            if (this.includeDependencies() && (dependency = this.getProject().getDependency()) != null && !this.allDependenciesOpened(dependency)) {
                MessageDialog.showError((UiContainer)this.getOwnerWindow(), ProjectMsg.PROJECT_DEPENDENCY_CLOSED);
                result = false;
            }
            return result;
        }

        @Override
        protected UiComponent createCenterPage(UiContainer parent) {
            this.setPageTitle(ProjectMsg.EXPORT_TYPE);
            this.setPageDesc(ProjectMsg.EXPORT_TYPE_DESCR);
            Panel panel = new Panel(parent);
            panel.setLayout(new BorderLayout(5, 5));
            Panel dependenciesPanel = this.buildDependenciesPanel(panel);
            Panel librariesPanel = this.buildLibrariesPanel(panel);
            panel.add(dependenciesPanel, "North");
            panel.add(librariesPanel, "Center");
            return panel;
        }

        private boolean allDependenciesOpened(Project project) {
            if (!project.isOpen()) {
                return false;
            }
            boolean result = true;
            Project dependency = project.getDependency();
            if (dependency != null) {
                result = this.allDependenciesOpened(dependency);
            }
            return result;
        }

        private Project getProject() {
            return ((ExportTypeStep)this.getWizardStep()).getProjectKeeper().getProject();
        }

        private Panel buildDependenciesPanel(UiContainer parent) {
            Panel panel = new Panel(parent, ProjectMsg.DEPENDENCIES);
            panel.setLayout(new BorderLayout());
            Project dependency = this.getProject().getDependency();
            boolean hasDependency = dependency != null;
            this.includeDependenciesCheckBox = CheckBox.create((UiContainer)panel, ProjectUiMsg.INCLUDE_BASE_PROJECT);
            this.includeDependenciesCheckBox.setSelected(hasDependency);
            this.includeDependenciesCheckBox.setEnabled(hasDependency);
            panel.add(this.includeDependenciesCheckBox, "Center");
            return panel;
        }

        private Panel buildLibrariesPanel(UiContainer parent) {
            String lastExportedType = CommonPreferences.getInstance().getLastExportedType();
            ExportType lastExportType = Str.isEmpty(lastExportedType) ? ExportType.getDefault() : ExportType.getExportTypeByName((String)lastExportedType);
            Panel panel = new Panel(parent, ProjectMsg.LIBRARIES);
            panel.setLayout(new BoxLayout(panel, 1));
            RadioButton<ExportType> noneButton = new RadioButton<ExportType>((UiContainer)panel, ProjectMsg.NONE_EXPORT);
            noneButton.setItem(ExportType.EXCLUDE_ALL_LIBRARIES);
            noneButton.setSelected(lastExportType.equals(noneButton.getItem()));
            RadioButton<ExportType> expressButton = new RadioButton<ExportType>((UiContainer)panel, ProjectMsg.EXPRESS_EXPORT);
            expressButton.setItem(ExportType.INCLUDE_ALL_LIBRARIES);
            expressButton.setSelected(lastExportType.equals(expressButton.getItem()));
            RadioButton<ExportType> enterpriseButton = new RadioButton<ExportType>((UiContainer)panel, ProjectMsg.ENTERPRISE_EXPORT);
            enterpriseButton.setItem(ExportType.INCLUDE_ONLY_VERSIONABLE_LIBRARIES);
            enterpriseButton.setSelected(lastExportType.equals(enterpriseButton.getItem()));
            this.buttonGroup = new ButtonGroup();
            this.buttonGroup.add(noneButton);
            this.buttonGroup.add(expressButton);
            this.buttonGroup.add(enterpriseButton);
            panel.add(noneButton);
            panel.add(expressButton);
            panel.add(enterpriseButton);
            return panel;
        }
    }
}

