/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.ui;

import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Month;
import oracle.bpm.lang.Week;
import oracle.bpm.project.model.MonthlySchedule;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.Schedule;
import oracle.bpm.project.model.ScheduleEntry;
import oracle.bpm.project.model.ScheduleType;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.ui.ComboBoxCell;
import oracle.bpm.project.ui.DayCell;
import oracle.bpm.project.ui.ScheduleModel;
import oracle.bpm.project.ui.TimeCell;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.EnumRadioPanel;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TableCell;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiType;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.CellEditorListener;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableColumn;
import oracle.bpm.ui.text.TimeField;

public class SchedulePanel
extends Panel {
    private CardLayout cardLayout;
    private Panel cardPanel;
    private CheckBox holidaysCheckBox;
    private EnumRadioPanel scheduleTypePanel;
    private static final int ROWS = 5;

    public SchedulePanel(UiContainer parent, Schedule schedule) {
        super(parent);
        this.setLayout(new RelativeLayout());
        if (schedule == null) {
            schedule = new Schedule();
        }
        Panel holidaysCheckBoxPanel = SchedulePanel.createPanelWithBorder(this);
        holidaysCheckBoxPanel.setLayout(new FlowLayout(1, 0, 0));
        this.holidaysCheckBox = CheckBox.create((UiContainer)holidaysCheckBoxPanel, UIMsg.RUNS_ON_HOLIDAYS);
        this.holidaysCheckBox.setSelected(schedule.getRunsOnHolidays());
        this.holidaysCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Schedule schedule = SchedulePanel.this.getSchedule();
                if (schedule != null) {
                    schedule.setRunsOnHolidays(SchedulePanel.this.holidaysCheckBox.isSelected());
                }
            }
        });
        holidaysCheckBoxPanel.add(this.holidaysCheckBox);
        Panel typePanel = this.createScheduleTypePanel(this);
        ToolBar toolBar = this.createToolBar(this);
        this.cardPanel = new Panel(this);
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout(this.cardLayout);
        this.cardPanel.add(this.createTablePanel(this.cardPanel, ScheduleType.DAILY), ScheduleType.DAILY.getString());
        this.cardPanel.add(this.createTablePanel(this.cardPanel, ScheduleType.WEEKLY), ScheduleType.WEEKLY.getString());
        this.cardPanel.add(this.createTablePanel(this.cardPanel, ScheduleType.MONTHLY), ScheduleType.MONTHLY.getString());
        this.add(holidaysCheckBoxPanel, "holidaysCheckBox");
        this.add(typePanel, "typePanel");
        this.add(toolBar, "toolBar");
        this.add(this.cardPanel, "table");
        this.layoutComponents();
        this.scheduleTypePanel.setSelectedEnumValue((Enum)(schedule.size() == 0 ? ScheduleType.DAILY : schedule.first().getType()));
    }

    public static void main(String[] args) {
        UiType type = UiType.SWT;
        if (args.length > 0 && args[0].trim().toUpperCase().equals("SWT")) {
            type = UiType.SWT;
        }
        Ui.initialize(type);
        Dialog dialog = new Dialog(null);
        UiContainer container = dialog.getContentPane();
        SchedulePanel panel = new SchedulePanel(container, null);
        container.add(panel, "Center");
        dialog.setVisible(true);
    }

    public Schedule getSchedule() {
        return this.getEntryTable().getSchedule();
    }

    public Table getTable() {
        return this.getEntryTable().getTable();
    }

    public EntriesTable getEntryTable() {
        return this.getTableForType(this.getScheduleType());
    }

    public void reset() {
        this.getSchedule().clear();
        this.showScheduleTable();
    }

    public void setHolidaysVisible(boolean b) {
        this.holidaysCheckBox.setVisible(b);
    }

    public void setSchedule(Schedule schedule) {
        ScheduleType type = schedule.size() == 0 ? ScheduleType.DAILY : schedule.first().getType();
        this.scheduleTypePanel.setSelectedEnumValue((Enum)type);
        this.getEntryTable().setSchedule(schedule);
        this.getEntryTable().getModel().fireTableDataChanged();
    }

    public void check() throws ProjectException {
        boolean noErrors = true;
        if (this.getScheduleType().equals((Object)ScheduleType.MONTHLY)) {
            Schedule schedule = this.getSchedule();
            for (int i = 0; i < schedule.size(); ++i) {
                MonthlySchedule monthlySchedule = (MonthlySchedule)schedule.get(i);
                noErrors = noErrors && monthlySchedule.check();
            }
        }
        if (!noErrors) {
            throw new ProjectException((ProjectObject)this.getSchedule(), ProjectModelMsg.SCHEDULE_ERROR);
        }
    }

    private UiComponent createTablePanel(UiContainer parent, ScheduleType scheduleType) {
        return new EntriesTable(parent, new Schedule(), scheduleType);
    }

    private ToolBar createToolBar(UiContainer parent) {
        ToolBar toolBar = new ToolBar(parent, ToolBar.VERTICAL);
        BaseAction newAction = new BaseAction(UIMsg.NEW){

            @Override
            public void run() {
                EntriesTable entryTable = SchedulePanel.this.getEntryTable();
                Table table = entryTable.getTable();
                entryTable.addScheduleEntry(ScheduleEntry.create((ScheduleType)SchedulePanel.this.getScheduleType()));
                table.setSelectionInterval(table.getRowCount() - 1, table.getRowCount() - 1);
            }
        };
        BaseAction removeAction = new BaseAction(UIMsg.REMOVE){

            @Override
            public void run() {
                SchedulePanel.this.getEntryTable().removeCurrentScheduleEntry();
            }
        };
        toolBar.add(newAction);
        toolBar.add(removeAction);
        return toolBar;
    }

    private Panel createScheduleTypePanel(UiContainer parent) {
        Panel panel = new Panel(parent);
        RelativeLayout layout = new RelativeLayout();
        panel.setLayout(layout);
        this.scheduleTypePanel = EnumRadioPanel.create(panel, (Enum[])ScheduleType.values(), true);
        this.scheduleTypePanel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SchedulePanel.this.showScheduleTable();
            }
        });
        panel.add(this.scheduleTypePanel, "typePanel");
        layout.addConstraint("typePanel", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 5));
        layout.addConstraint("typePanel", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 5));
        layout.addConstraint("typePanel", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT, -5));
        return panel;
    }

    private ScheduleType getScheduleType() {
        return (ScheduleType)this.scheduleTypePanel.getSelectedEnumValue();
    }

    private void layoutComponents() {
        RelativeLayout layout = (RelativeLayout)this.getLayout();
        layout.addConstraint("holidaysCheckBox", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 5));
        layout.addConstraint("holidaysCheckBox", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("holidaysCheckBox", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT));
        layout.addConstraint("typePanel", AttributeType.TOP, new AttributeConstraint("holidaysCheckBox", AttributeType.BOTTOM));
        layout.addConstraint("typePanel", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("typePanel", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT));
        layout.addConstraint("table", AttributeType.TOP, new AttributeConstraint("typePanel", AttributeType.BOTTOM, 5));
        layout.addConstraint("table", AttributeType.LEFT, new AttributeConstraint("typePanel", AttributeType.LEFT));
        layout.addConstraint("table", AttributeType.RIGHT, new AttributeConstraint("toolBar", AttributeType.LEFT, -2));
        layout.addConstraint("toolBar", AttributeType.TOP, new AttributeConstraint("table", AttributeType.TOP));
        layout.addConstraint("toolBar", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT));
    }

    private void showScheduleTable() {
        if (this.getScheduleType() != null) {
            this.cardLayout.show(this.cardPanel, this.getScheduleType().getString());
        }
    }

    private EntriesTable getTableForType(ScheduleType scheduleType) {
        return (EntriesTable)this.cardLayout.getComponent(scheduleType.getString());
    }

    public static class EntriesTable
    extends Panel {
        private DayCell dayCell;
        private Table table;

        public EntriesTable(UiContainer parent, Schedule schedule, ScheduleType type) {
            super(parent);
            this.init(schedule, type);
        }

        public Table getTable() {
            return this.table;
        }

        public void setSchedule(Schedule schedule) {
            this.getModel().setSchedule(schedule);
            this.dayCell.setSchedule(schedule);
        }

        public Schedule getSchedule() {
            return this.getModel().getSchedule();
        }

        public void addScheduleEntry(ScheduleEntry scheduleEntry) {
            this.getModel().addScheduleEntry(scheduleEntry);
        }

        public void removeCurrentScheduleEntry() {
            if (this.table.getCellEditor() != null) {
                this.table.getCellEditor().stopCellEditing();
            }
            this.getModel().removeScheduleEntry(this.table.getSelectedRow());
        }

        private ScheduleModel getModel() {
            return (ScheduleModel)this.table.getModel();
        }

        private void init(Schedule schedule, ScheduleType scheduleType) {
            this.setLayout(new BorderLayout());
            this.table = new Table((UiContainer)this, new ScheduleModel(schedule, scheduleType));
            this.add(this.table, "Center");
            this.table.setPreferredRows(5);
            TimeCell timeCell = new TimeCell(TimeField.Style.TIME, TimeField.Format.SHORT, Interval.class);
            ComboBoxCell monthCell = new ComboBoxCell(Month.values(), (Object)UIMsg.ALL);
            ComboBoxCell weekCell = new ComboBoxCell(Week.values(), (Object)UIMsg.DAY_OF_MONTH);
            this.dayCell = new DayCell(schedule);
            CellEditorListener listener = new CellEditorListener(){

                @Override
                public void editingCanceled(ChangeEvent e) {
                    EntriesTable.this.dayCell.revalidate();
                }

                @Override
                public void editingStopped(ChangeEvent e) {
                    EntriesTable.this.dayCell.revalidate();
                }
            };
            monthCell.editor().addCellEditorListener(listener);
            weekCell.editor().addCellEditorListener(listener);
            int column = 0;
            if (scheduleType == ScheduleType.MONTHLY) {
                this.setCell(column++, monthCell);
                this.setCell(column++, weekCell);
                this.setCell(column++, this.dayCell);
            } else if (scheduleType == ScheduleType.WEEKLY) {
                this.setCell(column++, this.dayCell);
            }
            this.setCell(column, timeCell);
        }

        private void setCell(int column, TableCell tableCell) {
            TableColumn tc = this.table.getColumn(column);
            tc.setLabelProvider(tableCell.renderer());
            tc.setCellEditor(tableCell.editor());
            int width = tableCell.getMinimumSize().getWidth();
            int tcWidth = tc.getWidth();
            if (width > tcWidth) {
                tc.setWidth(width);
            }
        }
    }
}

