/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.ui;

import oracle.bpm.project.model.Schedule;
import oracle.bpm.project.model.ScheduleEntry;
import oracle.bpm.project.model.ScheduleType;
import oracle.bpm.ui.table.AbstractTableModel;

class ScheduleModel
extends AbstractTableModel {
    private Schedule schedule;
    private ScheduleEntry scheduleEntry;
    private ScheduleType scheduleType;

    public ScheduleModel(Schedule schedule, ScheduleType type) {
        this.schedule = schedule;
        this.scheduleType = type;
        this.scheduleEntry = ScheduleEntry.create((ScheduleType)this.scheduleType);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Class getColumnClass(int columnIndex) {
        return this.getProto().getFieldClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return this.getProto().getFieldCount() - 1;
    }

    @Override
    public String getColumnName(int column) {
        return this.getProto().getField(column).getString();
    }

    @Override
    public int getRowCount() {
        return this.schedule.size();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.schedule.size()) {
            return;
        }
        this.schedule.get(rowIndex).setFieldValue(columnIndex, aValue);
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.schedule.get(rowIndex).getFieldValue(columnIndex);
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
    }

    public void addScheduleEntry(ScheduleEntry scheduleEntry) {
        this.getSchedule().add(scheduleEntry);
        int insertPosition = this.getSchedule().size() - 1;
        this.fireTableRowsInserted(insertPosition, insertPosition);
    }

    public void removeScheduleEntry(int position) {
        int n = this.getSchedule().size();
        if (n >= 1) {
            int selectedRow = position;
            if (selectedRow < 0 || selectedRow >= n) {
                selectedRow = n - 1;
            }
            this.getSchedule().remove(selectedRow);
            this.fireTableRowsDeleted(selectedRow, selectedRow);
        }
    }

    private ScheduleEntry getProto() {
        return this.scheduleEntry;
    }
}

