/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.ui;

import java.io.File;
import oracle.bpm.geom.Insets;
import oracle.bpm.project.io.FileSystemTokens;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.filechooser.DirectoryChooser;
import oracle.bpm.ui.layout.GridBagConstraints;
import oracle.bpm.ui.layout.GridBagLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.ValidFileTextField;

public class ProjectNameAndLocationPanel
extends Panel {
    private ValidFileTextField projectName;
    private TextField rootDir;

    public ProjectNameAndLocationPanel(UiContainer parent, String suggestedName, String suggestedRootDir) {
        super(parent);
        this.buildUi(suggestedName, suggestedRootDir);
    }

    public String getProjectName() {
        return this.projectName.getText();
    }

    public String getRootDir() {
        return this.rootDir.getText();
    }

    private void buildUi(String suggestedName, String suggestedRootDir) {
        this.setLayout(new BorderLayout());
        Panel panel = new Panel(this);
        panel.setLayout(new GridBagLayout());
        this.add(panel, "Center");
        this.projectName = new ValidFileTextField(panel, suggestedName, 20, FileSystemTokens.MAX_FILE_NAME_LENGTH, false);
        this.rootDir = new TextField((UiContainer)panel, suggestedRootDir);
        Button browseButton = new Button((UiContainer)panel, new ChooseFileAction());
        GridBagConstraints gbNoFill = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 8, 2), 0, 0);
        panel.add(Label.create((UiContainer)panel, ProjectMsg.PROJECT_NAME), gbNoFill);
        GridBagConstraints gbFill = gbNoFill.clone();
        gbFill.gridy = 1;
        gbFill.fill = 2;
        gbFill.weightx = 0.5;
        panel.add(this.projectName, gbFill);
        gbNoFill.gridy = 2;
        panel.add(Label.create((UiContainer)panel, ProjectMsg.PROJECT_ROOT_DIRECTORY), gbNoFill);
        gbFill.gridy = 3;
        gbFill.weightx = 1.0;
        panel.add(this.rootDir, gbFill);
        gbNoFill.gridy = 4;
        gbNoFill.anchor = 13;
        gbNoFill.insets = new Insets(2, 2, 2, 2);
        panel.add(browseButton, gbNoFill);
        UiUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectNameAndLocationPanel.this.projectName.selectAll();
                ProjectNameAndLocationPanel.this.projectName.requestFocus();
            }
        });
    }

    private class ChooseFileAction
    extends BaseAction {
        public ChooseFileAction() {
            super(UIMsg.BROWSE);
        }

        @Override
        public void run() {
            DirectoryChooser chooser = new DirectoryChooser();
            chooser.setCurrentDirectory(new File(ProjectNameAndLocationPanel.this.rootDir.getText()));
            int retValue = chooser.show(Ui.getRoot());
            if (retValue == 0 && chooser.getSelectedFile() != null) {
                String selectionFullPath = chooser.getSelectedFile().getAbsolutePath();
                ProjectNameAndLocationPanel.this.rootDir.setText(selectionFullPath);
            }
        }
    }
}

