/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import oracle.bpm.project.io.FileSystemTokens;
import oracle.bpm.project.io.fs.util.ProjectFileUtils;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.filechooser.DirectoryChooser;

public class ProjectChooser
extends DirectoryChooser {
    static final long serialVersionUID = -2085677971115470383L;
    static final long serialCheck = -441823266986580998L;

    private ProjectChooser(File currentDirectory, Msg msg) {
        this.setCurrentDirectory(currentDirectory);
        if (msg != null) {
            this.setName(msg.getString());
        }
    }

    public static ProjectChooser create(File currentDirectory, Msg msg) {
        return new ProjectChooser(currentDirectory, msg);
    }

    public static ProjectChooser create(String currentDirectory, Msg msg) {
        return new ProjectChooser(new File(currentDirectory), msg);
    }

    public static ProjectChooser create() {
        return new ProjectChooser(FileSystemTokens.getDefaultProjectsDir(), null);
    }

    public void approveSelection() {
        File tmp;
        File selectedFile = this.getSelectedFile();
        if (!selectedFile.exists() && (ProjectFileUtils.isFuego60Project((File)selectedFile) || ProjectFileUtils.isFuegoProjectByExtension((File)selectedFile)) && (tmp = new File(selectedFile.getPath())).exists()) {
            selectedFile = tmp;
            this.setSelectedFile(selectedFile);
        }
        if (this.isProjectFile(selectedFile)) {
            this.setSelectedFile(selectedFile);
        } else {
            this.setCurrentDirectory(selectedFile);
        }
    }

    private boolean isProjectFile(File f) {
        return FileSystemTokens.isValidProject((File)f);
    }

    class ProjectSelectionChangeListener
    implements PropertyChangeListener {
        private File file = null;
        private ProjectChooser fileChooser = null;

        public ProjectSelectionChangeListener(ProjectChooser fileChooser) {
            this.fileChooser = fileChooser;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if ("directoryChanged".equals(prop)) {
                this.file = (File)e.getNewValue();
                if (ProjectChooser.this.isProjectFile(this.file)) {
                    this.fileChooser.setSelectedFile(this.file);
                    this.fileChooser.approveSelection();
                }
            }
        }
    }
}

