/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.SampleBase;
import fuego.fuegoui.samples.SampleTableModel;
import fuego.fuegoui.samples.TableData;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.FontProvider;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.ToolBarItem;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.EditorListener;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.tree.AbstractTreeTableModel;
import oracle.bpm.ui.tree.TreeNode;
import oracle.bpm.ui.tree.TreePath;
import oracle.bpm.ui.treetable.TreeTable;
import oracle.bpm.ui.treetable.TreeTableColumn;
import oracle.bpm.ui.treetable.TreeTableModel;

class SampleTreeTable
extends SampleBase {
    private SampleTreeTable() {
        super("Tree Table");
    }

    public static SampleTreeTable create() {
        return new SampleTreeTable();
    }

    @Override
    public UiComponent buildEditorPanel(UiContainer parent) {
        Panel panel = new Panel(parent);
        panel.setLayout(new BorderLayout());
        final TreeTable treeTable = new TreeTable(panel, new SampleTreeTableModel());
        treeTable.getColumn(8).setImage(Image.create(UIMsg.ERROR));
        treeTable.addEditorListener(new EditorListener(){

            @Override
            public void editingStopped() {
                System.out.println("SampleTable.editingStopped");
            }

            @Override
            public void editingStarted() {
                System.out.println("SampleTable.editingStarted");
            }
        });
        BaseAction showRootAction = new BaseAction(UIMsg.PIN_ON){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBarItem item = (ToolBarItem)e.getSource();
                treeTable.setRootVisible(item.isEnabled());
            }
        };
        Panel actionPanel = new Panel(panel);
        BaseAction selectionPathAction = new BaseAction(UIMsg.TO_MSG("Get Selected Path")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath[] treePath = treeTable.getSelectionPaths();
                if (treePath.length > 0) {
                    System.out.println("Sample TreeTable Selected Path=" + treePath[0]);
                }
            }
        };
        BaseAction expandPathAction = new BaseAction(UIMsg.TO_MSG("Expand Path")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath[] treePath = treeTable.getSelectionPaths();
                if (treePath.length > 0) {
                    treeTable.expandPath(treePath[0]);
                    System.out.println("Sample TreeTable Expand Path=" + treePath[0]);
                }
            }
        };
        BaseAction collapsePathAction = new BaseAction(UIMsg.TO_MSG("Collapse Path")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath[] treePath = treeTable.getSelectionPaths();
                if (treePath.length > 0) {
                    treeTable.collapsePath(treePath[0]);
                    System.out.println("Sample TreeTable Collapse Path=" + treePath[0]);
                }
            }
        };
        ToolBar toolBar = new ToolBar(panel);
        toolBar.addToggleButton(showRootAction);
        actionPanel.add(new Button((UiContainer)actionPanel, selectionPathAction));
        actionPanel.add(new Button((UiContainer)actionPanel, expandPathAction));
        actionPanel.add(new Button((UiContainer)actionPanel, collapsePathAction));
        panel.add(toolBar, "North");
        panel.add(treeTable, "Center");
        panel.add(actionPanel, "South");
        SampleTreeTable.applyProviders(treeTable, 0);
        SampleTreeTable.applyProviders(treeTable, 2);
        return panel;
    }

    private static void applyProviders(TreeTable treeTable, int columnIndex) {
        TreeTableColumn column = treeTable.getColumn(columnIndex);
        column.setFontProvider(new MyFontProvider(treeTable.getFont()));
        column.setColorProvider(new MyColorProvider());
        column.setLabelProvider(new MyLabelProvider());
    }

    private static class SampleTreeTableModel
    extends AbstractTreeTableModel {
        private static TableData[] DATA = SampleTableModel.getTableData();
        private static final int COLUMN_STRING = 0;
        private static final int COLUMN_INTEGER = 1;
        private static final int COLUMN_LONG = 2;
        private static final int COLUMN_FLOAT = 3;
        private static final int COLUMN_DOUBLE = 4;
        private static final int COLUMN_BOOLEAN = 5;
        private static final int COLUMN_COLOR = 8;
        private static final int COLUMN_FONT = 9;
        private static final int COLUMN_COMBO = 10;
        private static final int COLUMN_CUSTOM = 11;
        private static final Msg[] TITLES = SampleTableModel.TITLES.toArray();
        static final Class[] COLUMN_CLASS = new Class[]{TreeTableModel.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class, Time.class, Interval.class, Color.class, Font.class, Object.class, Object.class};

        public SampleTreeTableModel() {
            super(MyTreeNode.create(DATA[0]));
            this.init();
        }

        @Override
        public boolean isCellEditable(Object node, int column) {
            return true;
        }

        @Override
        public Object getChild(Object parent, int index) {
            return ((TreeNode)parent).getChildAt(index);
        }

        @Override
        public int getChildCount(Object parent) {
            return ((TreeNode)parent).getChildCount();
        }

        @Override
        public Class getColumnClass(int column) {
            return COLUMN_CLASS[column];
        }

        @Override
        public int getColumnCount() {
            return TITLES.length;
        }

        @Override
        public String getColumnName(int column) {
            return TITLES[column].getString();
        }

        @Override
        public Object getParent(Object node) {
            return ((TreeNode)node).getParent();
        }

        @Override
        public void setValueAt(Object value, Object node, int column) {
            TreeNode treeNode = (TreeNode)node;
            TableData data = (TableData)treeNode.getUserObject();
            switch (column) {
                case 0: {
                    data.setString(value.toString());
                    return;
                }
                case 1: {
                    data.setInteger((Integer)value);
                    return;
                }
                case 2: {
                    data.setLong((Long)value);
                    return;
                }
                case 3: {
                    data.setFloat((Float)value);
                    return;
                }
                case 4: {
                    data.setDouble((Double)value);
                    return;
                }
                case 5: {
                    data.setBool((Boolean)value);
                    return;
                }
                case 8: {
                    data.setColor((Color)value);
                    return;
                }
                case 9: {
                    data.setFont((Font)value);
                    return;
                }
                case 10: {
                    data.setComboValue(value);
                    return;
                }
                case 11: {
                    data.setCustomValue(value);
                }
            }
        }

        @Override
        public Object getValueAt(Object node, int column) {
            TreeNode treeNode = (TreeNode)node;
            TableData data = (TableData)treeNode.getUserObject();
            switch (column) {
                case 0: {
                    return data.getString();
                }
                case 1: {
                    return data.getInteger();
                }
                case 2: {
                    return data.getLong();
                }
                case 3: {
                    return data.getFloat();
                }
                case 4: {
                    return data.getDouble();
                }
                case 5: {
                    return data.getBool();
                }
                case 8: {
                    return data.getColor();
                }
                case 9: {
                    return data.getFont();
                }
                case 10: {
                    return data.getComboValue();
                }
                case 11: {
                    return data.getCustomValue();
                }
            }
            return "";
        }

        private MyTreeNode getRootNode() {
            return (MyTreeNode)this.getRoot();
        }

        private void init() {
            MyTreeNode root = this.getRootNode();
            for (int i = 1; i < DATA.length; ++i) {
                MyTreeNode child = MyTreeNode.create(DATA[i]);
                for (int j = i + 1; j < DATA.length; ++j) {
                    MyTreeNode subChild = MyTreeNode.create(DATA[j]);
                    for (int k = j + 1; k < DATA.length; ++k) {
                        subChild.add(MyTreeNode.create(DATA[k]));
                    }
                    child.add(subChild);
                }
                root.add(child);
            }
        }
    }

    private static class MyTreeNode
    extends TreeNode {
        private MyTreeNode(TableData object) {
            super(object);
        }

        public static MyTreeNode create(TableData object) {
            return new MyTreeNode(object);
        }

        @Override
        public String toString() {
            return this.getUserObject().getString();
        }

        @Override
        public TableData getUserObject() {
            return (TableData)super.getUserObject();
        }
    }

    private static class MyLabelProvider
    extends LabelProvider.Default {
        private MyLabelProvider() {
        }

        @Override
        public Image getIcon(Object element) {
            return Image.create(UIMsg.MANDATORY_FIELD);
        }

        @Override
        public String getText(Object element) {
            return "[" + element + "]";
        }
    }

    private static class MyFontProvider
    implements FontProvider {
        private Font defaultFont;

        MyFontProvider(Font defaultFont) {
            this.defaultFont = defaultFont;
        }

        public Font getFont(Object element) {
            return this.defaultFont.applyStyle(FontStyle.BOLD_ITALIC);
        }
    }

    private static class MyColorProvider
    implements ColorProvider {
        private MyColorProvider() {
        }

        public Color getBackground(Object element) {
            return Color.GREEN;
        }

        public Color getForeground(Object element) {
            return Color.RED;
        }
    }
}

