/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.TableData;
import java.text.DateFormatSymbols;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.ui.table.ProviderTableModel;

class SampleTableModel
extends ProviderTableModel<TableData> {
    private boolean isEditable;
    static final MsgList TITLES = MsgList.create(Msg.QUOTE("String"), Msg.QUOTE("Integer"), Msg.QUOTE("Long"), Msg.QUOTE("Float"), Msg.QUOTE("Double"), Msg.QUOTE("Boolean"), Msg.QUOTE("Time"), Msg.QUOTE("Interval"), Msg.QUOTE("Color"), Msg.QUOTE("Font"), Msg.QUOTE("Combo"), Msg.QUOTE("Custom"));
    private static final Object[] VALUES = new Object[]{"Hight", "Medium", "Low"};
    static final int COLUMN_STRING = 0;
    static final int COLUMN_INTEGER = 1;
    static final int COLUMN_LONG = 2;
    static final int COLUMN_FLOAT = 3;
    static final int COLUMN_DOUBLE = 4;
    static final int COLUMN_BOOLEAN = 5;
    static final int COLUMN_TIME = 6;
    static final int COLUMN_INTERVAL = 7;
    static final int COLUMN_COLOR = 8;
    static final int COLUMN_FONT = 9;
    static final int COLUMN_COMBO = 10;
    static final int COLUMN_CUSTOM = 11;
    static final Class[] COLUMN_CLASS = new Class[]{String.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class, Time.class, Interval.class, Color.class, Font.class, Object.class, Object.class};

    public SampleTableModel() {
        this(false);
    }

    public SampleTableModel(boolean isEditable) {
        super(TITLES);
        this.isEditable = isEditable;
        this.populate(SampleTableModel.getTableData());
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.isEditable;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        TableData data = (TableData)this.getRow(row);
        switch (column) {
            case 0: {
                data.setString(value.toString());
                return;
            }
            case 1: {
                data.setInteger((Integer)value);
                return;
            }
            case 2: {
                data.setLong((Long)value);
                return;
            }
            case 3: {
                data.setFloat((Float)value);
                return;
            }
            case 4: {
                data.setDouble((Double)value);
                return;
            }
            case 5: {
                data.setBool((Boolean)value);
                return;
            }
            case 6: {
                data.setTime((Time)value);
                return;
            }
            case 7: {
                data.setInterval((Interval)value);
                return;
            }
            case 8: {
                data.setColor((Color)value);
                return;
            }
            case 9: {
                data.setFont((Font)value);
                return;
            }
            case 10: {
                data.setComboValue(value);
                return;
            }
            case 11: {
                data.setCustomValue(value);
            }
        }
    }

    @Override
    public Class getColumnClass(int column) {
        return COLUMN_CLASS[column];
    }

    @Override
    public Object getValueAt(int row, int column) {
        TableData data = (TableData)this.getRow(row);
        switch (column) {
            case 0: {
                return data.getString();
            }
            case 1: {
                return data.getInteger();
            }
            case 2: {
                return data.getLong();
            }
            case 3: {
                return data.getFloat();
            }
            case 4: {
                return data.getDouble();
            }
            case 5: {
                return data.getBool();
            }
            case 6: {
                return data.getTime();
            }
            case 7: {
                return data.getInterval();
            }
            case 8: {
                return data.getColor();
            }
            case 9: {
                return data.getFont();
            }
            case 10: {
                return data.getComboValue();
            }
            case 11: {
                return data.getCustomValue();
            }
        }
        return "";
    }

    static TableData[] getTableData() {
        DateFormatSymbols df = new DateFormatSymbols();
        String[] months = df.getMonths();
        TableData[] data = new TableData[months.length - 1];
        Font font = Font.valueOf("Arial", FontStyle.BOLD, 12);
        for (int i = 0; i < months.length - 1; ++i) {
            int r = i * 16 % 255;
            int g = (128 + 16 * i) % 255;
            int b = (255 - i * 16) % 255;
            data[i] = TableData.create(months[i], i, 1000L + (long)i, Float.valueOf(3.14f + (float)i), 100000.123 + (double)i, i % 2 == 0, Color.valueOf(r, g, b), font, Time.now(), new Interval(), VALUES[i % 3], "Custom " + i);
        }
        return data;
    }

    private void insertRow(TableData data) {
        this.addRow(data);
    }

    private void populate(TableData[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.insertRow(data[i]);
        }
    }
}

