/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.DynamicTableModel;
import fuego.fuegoui.samples.LocaleTableModel;
import fuego.fuegoui.samples.SampleBase;
import fuego.fuegoui.samples.SampleTableModel;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.table.AutoResizeMode;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableModel;

public class SampleTableDynamic
extends SampleBase {
    private SampleTableDynamic() {
        super("Table with Dynamic Model");
    }

    public static SampleTableDynamic create() {
        return new SampleTableDynamic();
    }

    @Override
    public UiComponent buildEditorPanel(UiContainer parent) {
        Panel mainPanel = new Panel(parent);
        mainPanel.setLayout(new BorderLayout());
        final SampleTableModel sampleModel = new SampleTableModel(true);
        final LocaleTableModel localeModel = new LocaleTableModel();
        final DynamicTableModel dynamicModel = new DynamicTableModel();
        final Table table = new Table((UiContainer)mainPanel, sampleModel);
        table.setAutoResizeMode(AutoResizeMode.OFF);
        Panel actionPanel = new Panel(mainPanel);
        actionPanel.setLayout(new FlowLayout());
        Button sampleModelButton = new Button((UiContainer)actionPanel, "Sample Model");
        sampleModelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.setModel(sampleModel);
                SampleTableDynamic.checkColumns(table);
            }
        });
        Button localeModelButton = new Button((UiContainer)actionPanel, "Locale Model");
        localeModelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.setModel(localeModel);
                SampleTableDynamic.checkColumns(table);
            }
        });
        Button dynamicModelButton = new Button((UiContainer)actionPanel, "Dynamic Model");
        dynamicModelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.setModel(dynamicModel);
                SampleTableDynamic.checkColumns(table);
            }
        });
        Button switchButton = new Button((UiContainer)actionPanel, "Switch Dynamic Model");
        switchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableModel model = table.getModel();
                if (model instanceof DynamicTableModel) {
                    ((DynamicTableModel)model).switchView();
                } else {
                    System.out.println("This option is only valid for DynamicTableModel");
                }
            }
        });
        Button refreshButton = new Button((UiContainer)actionPanel, "Refresh");
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("No implementado aun, va a ser usado para testear que se haga el dispose de los tableItem en SWT. Esto se usa en LogViewer");
            }
        });
        Button stopEditorButton = new Button((UiContainer)actionPanel, "Stop Editor");
        stopEditorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (table.isEditing()) {
                    table.getCellEditor().stopCellEditing();
                    System.out.println("Editor Stoped");
                }
            }
        });
        Button gotoTopButton = new Button((UiContainer)actionPanel, "Goto Top");
        gotoTopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.scrollToRow(0);
            }
        });
        Button gotoBottomButton = new Button((UiContainer)actionPanel, "Goto Bottom");
        gotoBottomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.scrollToRow(table.getRowCount() - 1);
            }
        });
        actionPanel.add(sampleModelButton);
        actionPanel.add(localeModelButton);
        actionPanel.add(dynamicModelButton);
        actionPanel.add(refreshButton);
        actionPanel.add(stopEditorButton);
        actionPanel.add(gotoTopButton);
        actionPanel.add(gotoBottomButton);
        mainPanel.add(actionPanel, "North");
        mainPanel.add(table, "Center");
        return mainPanel;
    }

    private static void checkColumns(Table table) {
        int columns = table.getColumnCount();
        System.out.print("SampleTableDynamic.checkColumn() Columns=" + columns);
        for (int i = 0; i < columns; ++i) {
            table.getColumn(i);
        }
        System.out.println(" -> OK");
    }
}

