/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import fuego.fuegoui.samples.SampleBase;
import fuego.fuegoui.samples.SamplePropertyGroup;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.prop.Factory;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyGroup;
import oracle.bpm.ui.prop.PropertyTable;
import oracle.bpm.ui.prop.PropertyTablePanel;
import oracle.bpm.ui.selection.DefaultSelectionProvider;

class SamplePropertyTable
extends SampleBase {
    private SamplePropertyTable() {
        super("Property Table");
    }

    public static SamplePropertyTable create() {
        return new SamplePropertyTable();
    }

    @Override
    public UiComponent buildEditorPanel(UiContainer parent) {
        Panel panel = new Panel(parent);
        panel.setLayout(new BorderLayout());
        final PropertyTable pt = SamplePropertyTable.buildPropertyTable(panel);
        BaseAction refreshAction = new BaseAction(UIMsg.REFRESH){

            @Override
            public void run() {
                pt.clearAll();
                SamplePropertyTable.populatePropertyTable(pt);
                pt.repaint();
            }
        };
        Button refreshButton = new Button((UiContainer)panel, refreshAction);
        panel.add(pt, "Center");
        panel.add(refreshButton, "South");
        return panel;
    }

    static PropertyTable buildPropertyTable(UiContainer parent) {
        PropertyTable pt = new PropertyTable(parent, new DefaultSelectionProvider());
        SamplePropertyTable.populatePropertyTable(pt);
        return pt;
    }

    private static void populatePropertyTable(PropertyTable pt) {
        PropertyTablePanel externalPanel = pt.addPropertyTablePanel(UIMsg.TO_MSG("Externas"));
        PropertyTablePanel instancePanel = pt.addPropertyTablePanel(UIMsg.TO_MSG("Instances"));
        PropertyTablePanel localPanel = pt.addPropertyTablePanel(UIMsg.TO_MSG("Local"));
        SamplePropertyTable.initGroup(pt, externalPanel);
        SamplePropertyTable.initGroup(pt, instancePanel);
        SamplePropertyTable.initGroup(pt, localPanel);
        pt.build();
    }

    private static void initGroup(PropertyTable pt, final PropertyTablePanel propertyPanel) {
        final PropertyGroup root = propertyPanel.getGroup();
        SamplePropertyGroup var1 = new SamplePropertyGroup("Var1", "Hola");
        root.add(var1);
        SamplePropertyGroup.populate(var1);
        SamplePropertyGroup var2 = new SamplePropertyGroup("Var2", "Chau");
        root.add(var2);
        SamplePropertyGroup.populate(var2);
        BaseAction addAction = new BaseAction(UIMsg.ADD){

            @Override
            public void run() {
                root.add(Factory.createText(UIMsg.TO_MSG("Dummy"), "dummy"));
                propertyPanel.reload();
            }
        };
        BaseAction removeAction = new BaseAction(UIMsg.REMOVE){

            @Override
            public void run() {
                Property selected = propertyPanel.getSelectedProperty();
                if (selected != null) {
                    propertyPanel.stopCellEditing();
                    if (root.remove(selected)) {
                        propertyPanel.reload();
                    }
                }
            }
        };
        propertyPanel.addAction(addAction);
        propertyPanel.addAction(removeAction);
    }
}

