/*
 * Decompiled with CFR 0.152.
 */
package fuego.fuegoui.samples;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Vector;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.EditorFactory;
import oracle.bpm.ui.prop.Factory;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyGroup;
import oracle.bpm.ui.prop.RendererFactory;
import oracle.bpm.ui.prop.impl.AbstractEditor;
import oracle.bpm.ui.prop.impl.FontProperty;

class SamplePropertyGroup
extends PropertyGroup {
    public SamplePropertyGroup(String key, String value) {
        super(key);
        this.setValue(value);
        SamplePropertyGroup.populate(this);
    }

    static void populate(PropertyGroup group) {
        String value = (String)group.getValue();
        group.add(Factory.createRegexpText(UIMsg.TO_MSG("Name"), value));
        group.add(Factory.createLongText(UIMsg.TO_MSG("Description"), "Description of " + value));
        group.add(Factory.createBoolean(UIMsg.TO_MSG("Boolean"), true));
        group.add(Factory.createColor(UIMsg.TO_MSG("Color"), Color.RED));
        FontProperty fontProperty = Factory.createFont(UIMsg.TO_MSG("Font"), Font.MONOSPACED);
        group.add(fontProperty);
        group.add(Factory.createCombo(UIMsg.TO_MSG("Locale"), SamplePropertyGroup.getLocales(), 1));
        group.add(Factory.createIntegerNumber(UIMsg.TO_MSG("Number"), 10, 1, 100, 1));
        group.add(Factory.createDoubleNumber(UIMsg.TO_MSG("Double Number"), 0.5, 0.1, 0.9, 0.1));
        group.add(new CustomProperty(UIMsg.TO_MSG("Locale"), SamplePropertyGroup.getLocales().get(0)));
        group.add(new CssProperty(UIMsg.TO_MSG("Support Css"), true));
        fontProperty.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Font newValue = (Font)evt.getNewValue();
                String name = newValue.getName();
                int size = newValue.getSize();
                System.out.println("fontProperty.propertyChange() name=" + name + " size=" + size);
            }
        });
    }

    private static Vector<Locale> getLocales() {
        Vector<Locale> result = new Vector<Locale>();
        result.add(Locale.US);
        result.add(Locale.ITALY);
        result.add(Locale.FRENCH);
        return result;
    }

    private static class CustomProperty
    extends AbstractProperty {
        public CustomProperty(Msg key, Locale value) {
            this.setKey(key);
            this.setValue(value);
            this.setPropertyRenderer(RendererFactory.DEFAULT_RENDERER);
            this.setPropertyEditor(new CustomEditor());
        }

        private static class CustomEditorDialog
        extends OkCancelDialog {
            private ComboBox localeComboBox;

            private CustomEditorDialog(UiWindow parent, Locale defaultValue) {
                super(parent, UIMsg.TO_MSG("Locale chooser"), true);
                this.init(defaultValue);
            }

            public Locale getLocale() {
                return (Locale)this.localeComboBox.getSelectedItem();
            }

            @Override
            public void ok() {
                this.setUserAccepted(true);
                this.close();
            }

            private void init(Locale defaultLocale) {
                Panel panel = new Panel(this.getContentPane());
                this.localeComboBox = UiFactory.createComboBox((UiContainer)panel, SamplePropertyGroup.getLocales().toArray());
                this.localeComboBox.setSelectedItem(defaultLocale);
                panel.setLayout(new BorderLayout());
                panel.add(this.localeComboBox, "Center");
                this.getContentPane().add(panel, "Center");
                this.pack();
                this.setLocationRelativeTo(this.getParent());
            }
        }

        private static class CustomEditor
        extends AbstractEditor {
            private ComboBox comboBox;

            private CustomEditor() {
            }

            @Override
            public Object getCellEditorValue() {
                return (Locale)this.comboBox.getSelectedItem();
            }

            @Override
            protected UiComponent getEditor(UiContainer parent) {
                return this.createEditor(parent);
            }

            private Panel createEditor(final UiContainer parent) {
                Panel mainPanel = new Panel(parent);
                RelativeLayout layout = new RelativeLayout();
                mainPanel.setLayout(layout);
                mainPanel.setOpaque(false);
                mainPanel.setBorder(null);
                this.comboBox = UiFactory.createComboBox((UiContainer)mainPanel, SamplePropertyGroup.getLocales().toArray());
                Button triggerButton = new Button(mainPanel);
                triggerButton.setAction(new BaseAction("..."){

                    @Override
                    public void run() {
                        CustomEditor.this.launchDialog(parent);
                    }
                });
                triggerButton.setDefaultCapable(false);
                triggerButton.setFocusPainted(false);
                mainPanel.add(this.comboBox, "comboBox");
                mainPanel.add(triggerButton, "button");
                this.layoutComponents(layout);
                this.updateLocale();
                return mainPanel;
            }

            private void layoutComponents(RelativeLayout layout) {
                layout.addConstraint("button", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT, -1));
                layout.addConstraint("button", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP));
                layout.addConstraint("button", AttributeType.BOTTOM, new AttributeConstraint("_container", AttributeType.BOTTOM));
                layout.addConstraint("button", AttributeType.WIDTH, new AttributeConstraint("_container", AttributeType.HEIGHT));
                layout.addConstraint("comboBox", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP));
                layout.addConstraint("comboBox", AttributeType.BOTTOM, new AttributeConstraint("_container", AttributeType.BOTTOM));
                layout.addConstraint("comboBox", AttributeType.RIGHT, new AttributeConstraint("button", AttributeType.LEFT, -1));
                layout.addConstraint("comboBox", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 1));
            }

            private void launchDialog(UiContainer parent) {
                Locale locale = (Locale)this.comboBox.getSelectedItem();
                CustomEditorDialog dialog = new CustomEditorDialog(parent.getOwnerWindow(), locale);
                dialog.setVisible(true);
                if (dialog.userAccepted()) {
                    Locale newLocale = dialog.getLocale();
                    Property property = this.getProperty();
                    property.setValue(newLocale);
                    this.updateLocale();
                    this.stopCellEditing();
                } else {
                    this.cancelCellEditing();
                }
            }

            private void updateLocale() {
                Property property = this.getProperty();
                Locale locale = (Locale)property.getValue();
                if (locale != null && this.comboBox != null) {
                    this.comboBox.setSelectedItem(locale);
                }
            }
        }
    }

    private static class CssProperty
    extends PropertyGroup {
        private AbstractProperty name;
        private AbstractProperty size;

        public CssProperty(Msg key, boolean value) {
            super(key);
            this.setValue(value);
            this.setPropertyRenderer(RendererFactory.BOOLEAN_RENDERER);
            this.setPropertyEditor(EditorFactory.BOOLEAN_EDITOR);
            this.setEditable(true);
            this.name = Factory.createText(UIMsg.NAME, "Css name");
            this.name.setEditable(value);
            this.size = Factory.createIntegerNumber(UIMsg.SIZE, 100, 10, 200, 1);
            this.size.setEditable(value);
            this.add(this.name);
            this.add(this.size);
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Boolean newValue = (Boolean)evt.getNewValue();
                    CssProperty.this.name.setEditable(newValue);
                    CssProperty.this.size.setEditable(newValue);
                }
            });
        }
    }
}

